/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.tcp.codec;

import com.tsi.app.common.app.AppUtils;
import com.tsi.app.common.utils.TimeUtils;
import com.tsi.app.common.xnet.NettyUtils;
import com.tsi.comm.server.mybatis.vo.AlarmOccrVo;
import com.tsi.comm.server.mybatis.vo.NodeStatusVo;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.process.packet.TsiCvimPacketProcess;
import com.tsi.comm.server.protocol.TsiCpuPacket;
import com.tsi.comm.server.repository.TsiAlarmManager;
import com.tsi.comm.server.repository.TsiNodeManager;
import com.tsi.comm.server.repository.TsiSessionManager;
import com.tsi.comm.server.repository.TsiTpmsManager;
import com.tsi.comm.server.vo.TsiAlarmConfigVo;
import com.tsi.comm.server.vo.TsiNodeVo;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class CvimServerByteBufMessageDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final Logger log = LoggerFactory.getLogger(CvimServerByteBufMessageDecoder.class);
    private final TsiCvimPacketProcess tsiCvimPacketService;
    private final TsiCvimDbmsProcess tsiCvimDbmsService;

    public CvimServerByteBufMessageDecoder(TsiCvimDbmsProcess tsiCvimDbmsService) {
        this.tsiCvimDbmsService = tsiCvimDbmsService;
        this.tsiCvimPacketService = (TsiCvimPacketProcess)AppUtils.getBean(TsiCvimPacketProcess.class);
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> list) throws Exception {
        try {
            long msec = TimeUtils.currentTimeSeconds();
            long nsec = System.nanoTime();
            if (byteBuf == null) {
                log.error("Receive: Packet frame packet error. length field data error");
                ctx.close();
                return;
            }
            int readableBytes = byteBuf.readableBytes();
            if (readableBytes < 10) {
                log.error("Receive: Packet readableBytes too small: {}, required min size: {}", (Object)readableBytes, (Object)10);
                ctx.close();
                return;
            }
            long nodeId = byteBuf.getUnsignedInt(6);
            TsiNodeVo nodeVo = (TsiNodeVo)ctx.channel().attr(TsiSessionManager.TSI_NODE_ATTRIBUTE_KEY).get();
            if (nodeVo == null) {
                nodeVo = this.attachNodeVo(nodeId, ctx.channel());
                ctx.channel().attr(TsiSessionManager.TSI_NODE_ATTRIBUTE_KEY).set((Object)nodeVo);
                NodeStatusVo status = new NodeStatusVo(1);
                status.setNodeId(nodeId);
                status.setStatus(1);
                status.setIpAddr(NettyUtils.getRemoteIpAddress((Channel)ctx.channel()));
                if (TsiSessionManager.getInstance().isServerRun()) {
                    this.tsiCvimDbmsService.add((Object)status, (int)Thread.currentThread().getId());
                } else {
                    log.error("Node Login but server not running: {}", (Object)status.toString());
                }
            }
            nodeVo.setLastCommTm(System.currentTimeMillis());
            TsiCpuPacket packet = new TsiCpuPacket(nodeId, msec, nsec, ctx.channel());
            packet.setBuf(new byte[readableBytes]);
            byteBuf.readBytes(packet.getBuf());
            packet.setObj((Object)nodeVo);
            this.tsiCvimPacketService.add((Object)packet, (int)Thread.currentThread().getId());
            packet.setAdd(System.nanoTime());
            TsiTpmsManager.getInstance().readPacket(packet);
        }
        catch (Exception e) {
            log.error("decode Exception: {}", (Object)e.getMessage());
        }
    }

    private TsiNodeVo attachNodeVo(long nodeId, Channel channel) {
        long start = System.nanoTime();
        TsiNodeVo nodeVo = TsiNodeManager.getInstance().get(nodeId);
        if (nodeVo == null) {
            log.warn("\uccab\ubc88\uc9f8 \uc218\uc2e0\ud55c \ud328\ud0b7\uc758 \ub178\ub4dc ID \uac00 \ub4f1\ub85d\ub418\uc5b4 \uc788\uc9c0 \uc54a\uc74c: {}, {}", (Object)nodeId, (Object)channel);
            nodeVo = new TsiNodeVo(nodeId, false, true, true);
            nodeVo.setCheckInstalled(true);
            nodeVo.setRegistered(false);
            TsiNodeManager.getInstance().put(nodeId, nodeVo);
            if (TsiAlarmManager.getInstance().checkAlarm(TsiAlarmConfigVo.COMM_01)) {
                AlarmOccrVo alarm = new AlarmOccrVo(4);
                alarm.setAlarmCode(TsiAlarmConfigVo.COMM_01);
                alarm.setAlarmTarget(Long.toString(nodeId));
                alarm.setAlarmValue(NettyUtils.getRemoteIpAddress((Channel)channel));
                this.tsiCvimDbmsService.add((Object)alarm, (int)Thread.currentThread().getId());
            }
        }
        nodeVo.setConnect(channel);
        TsiSessionManager.getInstance().addChannel(channel, nodeVo);
        log.info("Node Object Register, Node: {}: {}, {}", new Object[]{nodeId, TimeUtils.elapsedTime((long)start), Thread.currentThread().getId()});
        return nodeVo;
    }
}

