/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.tcp.initializer;

import com.tsi.app.common.app.AppUtils;
import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.tcp.codec.CvimServerByteBufMessageDecoder;
import com.tsi.comm.server.tcp.codec.CvimServerEncoder;
import com.tsi.comm.server.tcp.handler.CvimServerInboundMessageHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.timeout.IdleStateHandler;

public class CvimServerInitializer
extends ChannelInitializer<Channel> {
    private CvimServerByteBufMessageDecoder cvimServerByteBufMessageDecoder = (CvimServerByteBufMessageDecoder)AppUtils.getBean(CvimServerByteBufMessageDecoder.class);
    private CvimServerInboundMessageHandler cvimServerInboundMessageHandler = (CvimServerInboundMessageHandler)AppUtils.getBean(CvimServerInboundMessageHandler.class);
    private CvimServerEncoder cvimServerEncoder = (CvimServerEncoder)AppUtils.getBean(CvimServerEncoder.class);
    private TsiCvimServerConfig config;

    public CvimServerInitializer(TsiCvimServerConfig config) {
        this.config = config;
    }

    protected void initChannel(Channel channel) throws Exception {
        IdleStateHandler idleStateHandler = new IdleStateHandler(this.config.getReaderIdleTimeSeconds(), 0, 0);
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast("idleStateHandler", (ChannelHandler)idleStateHandler);
        pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(2048, 2, 2, -2, 0));
        pipeline.addLast("packetDecoder", (ChannelHandler)this.cvimServerByteBufMessageDecoder);
        pipeline.addLast("packetInboundHandler", (ChannelHandler)this.cvimServerInboundMessageHandler);
        pipeline.addLast("frameEncoder", (ChannelHandler)this.cvimServerEncoder);
    }
}

