/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.vo;

import com.tsi.app.common.cpu.dto.TsiCvimAbnormal;
import com.tsi.app.common.cpu.dto.TsiCvimControl;
import com.tsi.app.common.cpu.dto.TsiCvimDto;
import com.tsi.app.common.cpu.dto.TsiCvimStatus;
import com.tsi.app.common.cpu.enums.eLightsStatus;
import com.tsi.app.common.cpu.enums.eLightsType;
import com.tsi.app.common.cpu.enums.eTimeReliability;
import com.tsi.app.common.utils.ByteUtils;
import com.tsi.app.common.utils.CRC16Utils;
import com.tsi.app.common.utils.Counter;
import com.tsi.app.common.utils.SysUtils;
import com.tsi.comm.server.vo.TsiNodeAddDetailVo;
import com.tsi.comm.server.vo.TsiNodeAddVo;
import io.netty.channel.Channel;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsiNodeVo {
    private static final Logger log = LoggerFactory.getLogger(TsiNodeVo.class);
    private long nodeId;
    private boolean sendTest;
    private boolean sendNode;
    private boolean sendCvim;
    private boolean addNodeEnabled;
    private Channel channel;
    private boolean registered;
    private boolean installed;
    private boolean checkInstalled;
    private Counter connectCount = new Counter();
    private Counter disconnectCount = new Counter();
    private Counter recvPackets = new Counter();
    private Counter sendPackets = new Counter();
    private TsiCvimDto tsiCvimDto;
    TsiNodeAddVo tsiNodeAddVo;
    protected long connectTm;
    protected long disconnectTm;
    protected long lastCommTm;
    protected long recvTime;
    protected long handleTime;
    protected long queueTime;
    protected long endTime;
    private byte[] rawBytes = new byte[1];
    private byte[] nodePacket = new byte[1];

    public TsiNodeVo(long nodeId, boolean sendTest, boolean sendNode, boolean sendCvim) {
        this.nodeId = nodeId;
        this.sendTest = sendTest;
        this.sendNode = sendNode;
        this.sendCvim = sendCvim;
        this.addNodeEnabled = false;
        this.channel = null;
        this.installed = true;
        this.checkInstalled = true;
        this.connectTm = 0L;
        this.disconnectTm = 0L;
        this.lastCommTm = 0L;
    }

    public void initPacket() {
        this.tsiCvimDto = new TsiCvimDto();
        this.tsiCvimDto.setNodeId(this.nodeId);
    }

    public boolean isConnect() {
        return this.channel != null;
    }

    public void setConnect(Channel channel) {
        this.channel = channel;
        if (channel != null) {
            this.connectCount.increment();
            this.connectTm = System.currentTimeMillis();
        } else {
            this.disconnectCount.increment();
            this.disconnectTm = System.currentTimeMillis();
        }
    }

    public String getKey() {
        return String.valueOf(this.nodeId);
    }

    public byte[] getTestPacket() {
        return null;
    }

    public byte[] getCvimPacket() {
        return null;
    }

    public boolean parsing(byte[] packet) {
        int calcCheckSum;
        int statusCount;
        boolean result = true;
        if (packet[0] != 126 || packet[1] != 126) {
            log.info("Node: {}, STX Error: {}, {}", new Object[]{this.nodeId, packet[0], packet[1]});
            return false;
        }
        int dataLength = ByteUtils.getUnsignedShort((byte[])packet, (int)2);
        if (dataLength != 18 + 5 * (statusCount = packet[13] & 0x7F)) {
            log.info("Node: {}, Length Error: {}, status count: {}, {}", new Object[]{this.nodeId, dataLength, statusCount, 18 + 5 * statusCount});
            return false;
        }
        int recvCheckSum = ByteUtils.getUnsignedShort((byte[])packet, (int)(packet.length - 2));
        if (recvCheckSum != (calcCheckSum = CRC16Utils.CRC16_ccitt_cvim((byte[])packet, (int)2, (int)(dataLength - 2)))) {
            log.info("Node: {}, Check Sum Error: recv: {}, calc: {}", new Object[]{this.nodeId, recvCheckSum, calcCheckSum});
            return false;
        }
        this.initPacket();
        if (this.addNodeEnabled && this.tsiNodeAddVo != null) {
            for (Map.Entry obj : this.tsiNodeAddVo.getAddNodeMap().entrySet()) {
                if (((TsiNodeAddDetailVo)obj.getValue()).getNodeObj() == null) continue;
                ((TsiNodeAddDetailVo)obj.getValue()).getNodeObj().initPacket();
            }
        }
        ByteBuffer buffer = ByteBuffer.wrap(packet);
        TsiCvimControl tscControlInfo = this.tsiCvimDto.getTscControlInfo();
        TsiCvimAbnormal tscAbnormalInfo = this.tsiCvimDto.getTscAbnormalInfo();
        this.tsiCvimDto.setNodeId(this.nodeId);
        this.tsiCvimDto.setConnect(true);
        this.tsiCvimDto.setCollectTime(SysUtils.getSysTimeStr());
        byte stx1 = buffer.get();
        byte stx2 = buffer.get();
        int length = buffer.getShort() & 0xFFFF;
        byte opcode = buffer.get();
        byte version = buffer.get();
        long recvNodeId = (long)buffer.getInt() & 0xFFFFFFFFL;
        byte control = buffer.get();
        tscControlInfo.inManualControl = (control & 1) == 1;
        tscControlInfo.inFlashingControl = (control >> 1 & 1) == 1;
        tscControlInfo.inLightsOutControl = (control >> 2 & 1) == 1;
        tscControlInfo.inActuationControl = (control >> 3 & 1) == 1;
        tscControlInfo.inTransitionControl = (control >> 4 & 1) == 1;
        byte abnormal = buffer.get();
        tscAbnormalInfo.inSignalConflict = (abnormal & 1) == 1;
        tscAbnormalInfo.inCenterComm = (abnormal >> 1 & 1) == 1;
        tscAbnormalInfo.inScuComm = (abnormal >> 2 & 1) == 1;
        this.tsiCvimDto.setCycleElapsedTime(buffer.get() & 0xFF);
        byte stts = buffer.get();
        this.tsiCvimDto.setSignalStatusInfoCount(stts & 0x7F);
        long currTime = (long)buffer.getInt() & 0xFFFFFFFFL;
        for (int idx = 0; idx < this.tsiCvimDto.getSignalStatusInfoCount(); ++idx) {
            TsiNodeAddDetailVo detailVo;
            byte dirInfo = buffer.get();
            byte statusInfo = buffer.get();
            byte totalSeconds = buffer.get();
            byte remainingSeconds = buffer.get();
            byte directionCode = buffer.get();
            TsiCvimStatus status = new TsiCvimStatus();
            int dirAdd = dirInfo & 0xF;
            status.setLightsType(eLightsType.getByValue((int)(dirInfo >> 4 & 0xF)));
            status.setLightsStatus(eLightsStatus.getByValue((int)(statusInfo & 7)));
            status.setTimeReliability(eTimeReliability.getByValue((int)(statusInfo >> 7 & 1)));
            status.setReadyPedestrianSignal((statusInfo >> 6 & 1) == 1);
            status.setUnProtectedSignal((statusInfo >> 3 & 1) == 1);
            status.setTotalSeconds((int)totalSeconds);
            status.setRemainingSeconds((int)remainingSeconds);
            status.setDirectionCode((int)directionCode);
            if (dirAdd == 0) {
                this.tsiCvimDto.getSignalStatusInfos().add(status);
                continue;
            }
            if (this.tsiNodeAddVo == null || (detailVo = (TsiNodeAddDetailVo)this.tsiNodeAddVo.getAddNodeMap().get(directionCode * 1000 + dirAdd)) == null) continue;
            for (int dirIdx = 0; dirIdx < 2; ++dirIdx) {
                if (detailVo.getAddDirCode()[dirIdx] == 0) continue;
                if (dirIdx == 0) {
                    status.setDirectionCode((int)detailVo.getAddDirCode()[dirIdx]);
                    detailVo.getNodeObj().getTsiCvimDto().getSignalStatusInfos().add(status);
                    continue;
                }
                TsiCvimStatus statusTmp = new TsiCvimStatus();
                status.copy(statusTmp);
                statusTmp.setDirectionCode((int)detailVo.getAddDirCode()[dirIdx]);
                detailVo.getNodeObj().getTsiCvimDto().getSignalStatusInfos().add(statusTmp);
            }
        }
        Date date = new Date(currTime * 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+9"));
        this.tsiCvimDto.setTscDateTime(sdf.format(date));
        if (this.addNodeEnabled && this.tsiNodeAddVo != null) {
            this.makePacket(stx1, stx2, opcode, version, this.tsiCvimDto, currTime);
            for (Map.Entry obj : this.tsiNodeAddVo.getAddNodeMap().entrySet()) {
                if (((TsiNodeAddDetailVo)obj.getValue()).getNodeObj() == null) continue;
                ((TsiNodeAddDetailVo)obj.getValue()).getNodeObj().makePacket(stx1, stx2, opcode, version, this.tsiCvimDto, currTime);
            }
        } else {
            this.makeNodePacket(length);
        }
        return result;
    }

    public void makeNodePacket(int length) {
        this.nodePacket = null;
        if (length > 6) {
            int packetLen = length - 2 - 1 - 1 - 2;
            this.nodePacket = new byte[packetLen];
        } else {
            log.warn("makeNodePacket: The length must be at least {} bytes: {}, {}", new Object[]{6, this.nodeId, length});
        }
    }

    public void makePacket(byte stx1, byte stx2, byte opcode, byte version, TsiCvimDto tsiCvimDto, long currTime) {
        if (this.tsiCvimDto == null) {
            return;
        }
        if (tsiCvimDto != null) {
            this.tsiCvimDto.setConnect(true);
            this.tsiCvimDto.setCollectTime(tsiCvimDto.getCollectTime());
            this.tsiCvimDto.setTscDateTime(tsiCvimDto.getTscDateTime());
            this.tsiCvimDto.setCycleElapsedTime(tsiCvimDto.getCycleElapsedTime());
            this.tsiCvimDto.setTscControlInfo(tsiCvimDto.getTscControlInfo());
            this.tsiCvimDto.setTscAbnormalInfo(tsiCvimDto.getTscAbnormalInfo());
            this.tsiCvimDto.setSignalStatusInfoCount(this.tsiCvimDto.getSignalStatusInfos().size());
        } else {
            this.tsiCvimDto.setConnect(true);
            this.tsiCvimDto.setSignalStatusInfoCount(0);
        }
        int length = 16 + 5 * this.tsiCvimDto.getSignalStatusInfoCount() + 2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(2 + length);
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
        byteBuffer.put(stx1);
        byteBuffer.put(stx2);
        byteBuffer.put((byte)(length >> 8 & 0xFF));
        byteBuffer.put((byte)(length & 0xFF));
        byteBuffer.put(opcode);
        byteBuffer.put(version);
        byteBuffer.put((byte)(this.getNodeId() >> 24 & 0xFFL));
        byteBuffer.put((byte)(this.getNodeId() >> 16 & 0xFFL));
        byteBuffer.put((byte)(this.getNodeId() >> 8 & 0xFFL));
        byteBuffer.put((byte)(this.getNodeId() & 0xFFL));
        byte inManualControl = (byte)(this.tsiCvimDto.getTscControlInfo().inManualControl ? 1 : 0);
        byte inFlashingControl = (byte)(this.tsiCvimDto.getTscControlInfo().inFlashingControl ? 1 : 0);
        byte inLightsOutControl = (byte)(this.tsiCvimDto.getTscControlInfo().inLightsOutControl ? 1 : 0);
        byte inActuationControl = (byte)(this.tsiCvimDto.getTscControlInfo().inActuationControl ? 1 : 0);
        byte inTransitionControl = (byte)(this.tsiCvimDto.getTscControlInfo().inTransitionControl ? 1 : 0);
        byte control = (byte)(inManualControl | inFlashingControl << 1 | inLightsOutControl << 2 | inActuationControl << 3 | inTransitionControl << 4);
        byte inSignalConflict = (byte)(this.tsiCvimDto.getTscAbnormalInfo().inSignalConflict ? 1 : 0);
        byte inCenterComm = (byte)(this.tsiCvimDto.getTscAbnormalInfo().inCenterComm ? 1 : 0);
        byte inScuComm = (byte)(this.tsiCvimDto.getTscAbnormalInfo().inScuComm ? 1 : 0);
        byte abnormal = (byte)(inSignalConflict | inCenterComm << 1 | inScuComm << 2);
        byte sttsCount = (byte)this.tsiCvimDto.getSignalStatusInfoCount();
        int splitFlag = 1;
        byte signalStatusInfoCount = (byte)(sttsCount | splitFlag << 7);
        byteBuffer.put(control);
        byteBuffer.put(abnormal);
        byteBuffer.put((byte)this.tsiCvimDto.getCycleElapsedTime());
        byteBuffer.put(signalStatusInfoCount);
        byteBuffer.put((byte)(currTime >> 24 & 0xFFL));
        byteBuffer.put((byte)(currTime >> 16 & 0xFFL));
        byteBuffer.put((byte)(currTime >> 8 & 0xFFL));
        byteBuffer.put((byte)(currTime & 0xFFL));
        for (TsiCvimStatus status : this.tsiCvimDto.getSignalStatusInfos()) {
            byte lightsType = (byte)status.getLightsType().getValue();
            byte lightsStatus = (byte)status.getLightsStatus().getValue();
            byte unProtectedSignal = (byte)(status.isUnProtectedSignal() ? 1 : 0);
            byte readyPedestrianSignal = (byte)(status.isReadyPedestrianSignal() ? 1 : 0);
            byte timeReliability = (byte)status.getTimeReliability().getValue();
            byte statusFlag = (byte)(lightsStatus | unProtectedSignal << 3 | readyPedestrianSignal << 6 | timeReliability << 7);
            byteBuffer.put((byte)(lightsType << 4));
            byteBuffer.put(statusFlag);
            byteBuffer.put((byte)status.getTotalSeconds());
            byteBuffer.put((byte)status.getRemainingSeconds());
            byteBuffer.put((byte)status.getDirectionCode());
        }
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        this.makeNodePacket(length);
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public boolean isSendTest() {
        return this.sendTest;
    }

    public boolean isSendNode() {
        return this.sendNode;
    }

    public boolean isSendCvim() {
        return this.sendCvim;
    }

    public boolean isAddNodeEnabled() {
        return this.addNodeEnabled;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public boolean isCheckInstalled() {
        return this.checkInstalled;
    }

    public Counter getConnectCount() {
        return this.connectCount;
    }

    public Counter getDisconnectCount() {
        return this.disconnectCount;
    }

    public Counter getRecvPackets() {
        return this.recvPackets;
    }

    public Counter getSendPackets() {
        return this.sendPackets;
    }

    public TsiCvimDto getTsiCvimDto() {
        return this.tsiCvimDto;
    }

    public TsiNodeAddVo getTsiNodeAddVo() {
        return this.tsiNodeAddVo;
    }

    public long getConnectTm() {
        return this.connectTm;
    }

    public long getDisconnectTm() {
        return this.disconnectTm;
    }

    public long getLastCommTm() {
        return this.lastCommTm;
    }

    public long getRecvTime() {
        return this.recvTime;
    }

    public long getHandleTime() {
        return this.handleTime;
    }

    public long getQueueTime() {
        return this.queueTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public byte[] getRawBytes() {
        return this.rawBytes;
    }

    public byte[] getNodePacket() {
        return this.nodePacket;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public void setSendTest(boolean sendTest) {
        this.sendTest = sendTest;
    }

    public void setSendNode(boolean sendNode) {
        this.sendNode = sendNode;
    }

    public void setSendCvim(boolean sendCvim) {
        this.sendCvim = sendCvim;
    }

    public void setAddNodeEnabled(boolean addNodeEnabled) {
        this.addNodeEnabled = addNodeEnabled;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public void setCheckInstalled(boolean checkInstalled) {
        this.checkInstalled = checkInstalled;
    }

    public void setConnectCount(Counter connectCount) {
        this.connectCount = connectCount;
    }

    public void setDisconnectCount(Counter disconnectCount) {
        this.disconnectCount = disconnectCount;
    }

    public void setRecvPackets(Counter recvPackets) {
        this.recvPackets = recvPackets;
    }

    public void setSendPackets(Counter sendPackets) {
        this.sendPackets = sendPackets;
    }

    public void setTsiCvimDto(TsiCvimDto tsiCvimDto) {
        this.tsiCvimDto = tsiCvimDto;
    }

    public void setTsiNodeAddVo(TsiNodeAddVo tsiNodeAddVo) {
        this.tsiNodeAddVo = tsiNodeAddVo;
    }

    public void setConnectTm(long connectTm) {
        this.connectTm = connectTm;
    }

    public void setDisconnectTm(long disconnectTm) {
        this.disconnectTm = disconnectTm;
    }

    public void setLastCommTm(long lastCommTm) {
        this.lastCommTm = lastCommTm;
    }

    public void setRecvTime(long recvTime) {
        this.recvTime = recvTime;
    }

    public void setHandleTime(long handleTime) {
        this.handleTime = handleTime;
    }

    public void setQueueTime(long queueTime) {
        this.queueTime = queueTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setRawBytes(byte[] rawBytes) {
        this.rawBytes = rawBytes;
    }

    public void setNodePacket(byte[] nodePacket) {
        this.nodePacket = nodePacket;
    }
}

