/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.repository;

import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.protocol.TsiCpuPacket;
import com.tsi.comm.server.repository.TsiSessionManager;
import com.tsi.comm.server.vo.mariadb.CommStatusVo;
import com.tsi.comm.server.vo.mariadb.KafkaTransVo;
import com.tsi.comm.server.xnet.NetUtils;
import com.tsi.common.utils.Counter;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TsiTpmsManager {
    private static final Logger log = LoggerFactory.getLogger(TsiTpmsManager.class);
    private final TsiCvimDbmsProcess dbmsProcess;
    private final TsiSessionManager sessionManager;
    private final Counter readTPS = new Counter();
    private final Counter readBPS = new Counter();
    private final KafkaTransVo kafkaTransVo = new KafkaTransVo(3);

    @PostConstruct
    void init() {
        this.kafkaTransVo.setHostName(NetUtils.getHostName());
    }

    public void readPacket(TsiCpuPacket packet) {
        this.readTPS.increment();
        this.readBPS.add((long)packet.getBuf().length);
    }

    public void resetSecond(int serverId, String hostName) {
        CommStatusVo stat = new CommStatusVo(2);
        long trans = this.readTPS.reset();
        long bytes = this.readBPS.reset();
        stat.setHostName(hostName);
        stat.setId(serverId);
        stat.setTrans(trans);
        stat.setBytes(bytes);
        stat.setSessions(this.sessionManager.getChannelCount());
        this.dbmsProcess.add((Object)stat, 0);
    }

    public void resetMinute() {
    }

    public void resetDay() {
    }

    public TsiTpmsManager(TsiCvimDbmsProcess dbmsProcess, TsiSessionManager sessionManager) {
        this.dbmsProcess = dbmsProcess;
        this.sessionManager = sessionManager;
    }

    public KafkaTransVo getKafkaTransVo() {
        return this.kafkaTransVo;
    }
}

