/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.vo;

import com.tsi.comm.server.protocol.TsiCpuPacket;
import com.tsi.comm.server.repository.TsiAlarmManager;
import com.tsi.comm.server.vo.TsiNodeAddVo;
import com.tsi.common.utils.Counter;
import io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsiNodeVo {
    private static final Logger log = LoggerFactory.getLogger(TsiNodeVo.class);
    private long nodeId;
    private String ipAddr;
    private boolean sendTest;
    private boolean sendNode;
    private boolean sendCvim;
    private boolean addNodeEnabled;
    private Channel channel;
    private boolean registered;
    private boolean installed;
    private boolean checkInstalled;
    private Counter connectCount = new Counter();
    private Counter disconnectCount = new Counter();
    TsiNodeAddVo tsiNodeAddVo;
    protected long connectTm;
    protected long disconnectTm;
    protected long lastCommTm;
    protected long recvTime;
    protected long handleTime;
    protected long queueTime;
    protected long endTime;
    private boolean dump;
    private boolean tcpDump;
    private int pktQIdx;
    private int dbmsQIdx;
    private int logQIdx;
    private int sigCount;
    private final AtomicLong lastProcessTime = new AtomicLong(0L);
    private final AtomicLong droppedPacketCount = new AtomicLong(0L);
    private final AtomicInteger pendingPacketCount = new AtomicInteger(0);
    private final AtomicLong overlappingPacketCount = new AtomicLong(0L);
    private final AtomicLong averageProcessingTimeNanos = new AtomicLong(0L);

    public TsiNodeVo(long nodeId, String ipAddr, boolean sendTest, boolean sendNode, boolean sendCvim) {
        this.nodeId = nodeId;
        this.ipAddr = ipAddr;
        this.sendTest = sendTest;
        this.sendNode = sendNode;
        this.sendCvim = sendCvim;
        this.addNodeEnabled = false;
        this.channel = null;
        this.installed = true;
        this.checkInstalled = true;
        this.connectTm = 0L;
        this.disconnectTm = 0L;
        this.lastCommTm = 0L;
        this.dump = false;
        this.tcpDump = false;
        this.pktQIdx = 0;
        this.dbmsQIdx = 0;
        this.logQIdx = 0;
        this.sigCount = 0;
        this.tsiNodeAddVo = null;
    }

    public boolean isConnect() {
        return this.channel != null;
    }

    public synchronized boolean isProcessable(long intervalMillis) {
        long last;
        long now = System.currentTimeMillis();
        if (now - (last = this.lastProcessTime.get()) < intervalMillis) {
            this.droppedPacketCount.incrementAndGet();
            return false;
        }
        this.lastProcessTime.set(now);
        return true;
    }

    public long getDroppedPacketCount() {
        return this.droppedPacketCount.get();
    }

    public void packetProcessingStarted() {
        if (this.pendingPacketCount.getAndIncrement() > 0) {
            this.overlappingPacketCount.incrementAndGet();
        }
    }

    public void packetProcessingFinished(TsiCpuPacket packet) {
        long startTime;
        this.pendingPacketCount.decrementAndGet();
        if (packet.getEnd() > 0L && (startTime = packet.getTimespec().timestamp()) > 0L) {
            long durationNanos = System.nanoTime() - startTime;
            this.updateAverageProcessingTime(durationNanos);
        }
    }

    public long getOverlappingPacketCount() {
        return this.overlappingPacketCount.get();
    }

    public synchronized void updateAverageProcessingTime(long durationNanos) {
        long currentAvg = this.averageProcessingTimeNanos.get();
        if (currentAvg == 0L) {
            this.averageProcessingTimeNanos.set(durationNanos);
        } else {
            long newAvg = (currentAvg + durationNanos) / 2L;
            this.averageProcessingTimeNanos.set(newAvg);
        }
    }

    public long getAverageProcessingTimeMicros() {
        return TimeUnit.NANOSECONDS.toMicros(this.averageProcessingTimeNanos.get());
    }

    public synchronized void setConnect(Channel channel) {
        this.channel = channel;
        if (channel != null) {
            this.connectCount.increment();
            this.connectTm = System.currentTimeMillis();
        } else {
            this.disconnectCount.increment();
            this.disconnectTm = System.currentTimeMillis();
        }
    }

    public synchronized Channel connectChannel(Channel newChannel, TsiAlarmManager alarmManager, String remoteIpAddress) {
        Channel oldChannel = this.channel;
        if (oldChannel != null && oldChannel.isActive() && oldChannel != newChannel) {
            alarmManager.alarmDupConnect(Long.valueOf(this.getNodeId()), this.getIpAddr(), remoteIpAddress);
            oldChannel.close();
        }
        this.setConnect(newChannel);
        return oldChannel;
    }

    public synchronized boolean disconnectChannel(Channel channelToDisconnect) {
        if (this.channel == channelToDisconnect) {
            this.setConnect(null);
            return true;
        }
        return false;
    }

    public String getKey() {
        return String.valueOf(this.nodeId);
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public String getIpAddr() {
        return this.ipAddr;
    }

    public boolean isSendTest() {
        return this.sendTest;
    }

    public boolean isSendNode() {
        return this.sendNode;
    }

    public boolean isSendCvim() {
        return this.sendCvim;
    }

    public boolean isAddNodeEnabled() {
        return this.addNodeEnabled;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public boolean isCheckInstalled() {
        return this.checkInstalled;
    }

    public Counter getConnectCount() {
        return this.connectCount;
    }

    public Counter getDisconnectCount() {
        return this.disconnectCount;
    }

    public TsiNodeAddVo getTsiNodeAddVo() {
        return this.tsiNodeAddVo;
    }

    public long getConnectTm() {
        return this.connectTm;
    }

    public long getDisconnectTm() {
        return this.disconnectTm;
    }

    public long getLastCommTm() {
        return this.lastCommTm;
    }

    public long getRecvTime() {
        return this.recvTime;
    }

    public long getHandleTime() {
        return this.handleTime;
    }

    public long getQueueTime() {
        return this.queueTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public boolean isDump() {
        return this.dump;
    }

    public boolean isTcpDump() {
        return this.tcpDump;
    }

    public int getPktQIdx() {
        return this.pktQIdx;
    }

    public int getDbmsQIdx() {
        return this.dbmsQIdx;
    }

    public int getLogQIdx() {
        return this.logQIdx;
    }

    public int getSigCount() {
        return this.sigCount;
    }

    public AtomicLong getLastProcessTime() {
        return this.lastProcessTime;
    }

    public AtomicInteger getPendingPacketCount() {
        return this.pendingPacketCount;
    }

    public AtomicLong getAverageProcessingTimeNanos() {
        return this.averageProcessingTimeNanos;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public void setIpAddr(String ipAddr) {
        this.ipAddr = ipAddr;
    }

    public void setSendTest(boolean sendTest) {
        this.sendTest = sendTest;
    }

    public void setSendNode(boolean sendNode) {
        this.sendNode = sendNode;
    }

    public void setSendCvim(boolean sendCvim) {
        this.sendCvim = sendCvim;
    }

    public void setAddNodeEnabled(boolean addNodeEnabled) {
        this.addNodeEnabled = addNodeEnabled;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public void setCheckInstalled(boolean checkInstalled) {
        this.checkInstalled = checkInstalled;
    }

    public void setConnectCount(Counter connectCount) {
        this.connectCount = connectCount;
    }

    public void setDisconnectCount(Counter disconnectCount) {
        this.disconnectCount = disconnectCount;
    }

    public void setTsiNodeAddVo(TsiNodeAddVo tsiNodeAddVo) {
        this.tsiNodeAddVo = tsiNodeAddVo;
    }

    public void setConnectTm(long connectTm) {
        this.connectTm = connectTm;
    }

    public void setDisconnectTm(long disconnectTm) {
        this.disconnectTm = disconnectTm;
    }

    public void setLastCommTm(long lastCommTm) {
        this.lastCommTm = lastCommTm;
    }

    public void setRecvTime(long recvTime) {
        this.recvTime = recvTime;
    }

    public void setHandleTime(long handleTime) {
        this.handleTime = handleTime;
    }

    public void setQueueTime(long queueTime) {
        this.queueTime = queueTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public void setDump(boolean dump) {
        this.dump = dump;
    }

    public void setTcpDump(boolean tcpDump) {
        this.tcpDump = tcpDump;
    }

    public void setPktQIdx(int pktQIdx) {
        this.pktQIdx = pktQIdx;
    }

    public void setDbmsQIdx(int dbmsQIdx) {
        this.dbmsQIdx = dbmsQIdx;
    }

    public void setLogQIdx(int logQIdx) {
        this.logQIdx = logQIdx;
    }

    public void setSigCount(int sigCount) {
        this.sigCount = sigCount;
    }
}

