/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.tcp.handler;

import com.tsi.app.common.app.AppUtils;
import com.tsi.app.common.xnet.NettyUtils;
import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.mybatis.vo.AlarmOccrVo;
import com.tsi.comm.server.mybatis.vo.NodeStatusVo;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.process.packet.TsiCvimPacketProcess;
import com.tsi.comm.server.protocol.TsiCpuDisconnected;
import com.tsi.comm.server.repository.TsiAlarmManager;
import com.tsi.comm.server.repository.TsiSessionManager;
import com.tsi.comm.server.vo.TsiAlarmConfigVo;
import com.tsi.comm.server.vo.TsiNodeVo;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CvimServerIdleHandler
extends IdleStateHandler {
    private static final Logger log = LoggerFactory.getLogger(CvimServerIdleHandler.class);
    private final TsiCvimServerConfig config;
    private TsiCvimPacketProcess tsiCvimPacketService;
    private TsiCvimDbmsProcess tsiCvimDbmsService;

    public CvimServerIdleHandler(TsiCvimServerConfig config) {
        super(5, 0, 0);
        this.config = config;
        this.tsiCvimPacketService = (TsiCvimPacketProcess)AppUtils.getBean(TsiCvimPacketProcess.class);
        this.tsiCvimDbmsService = (TsiCvimDbmsProcess)AppUtils.getBean(TsiCvimDbmsProcess.class);
        log.error("Idle Config: {}", (Object)this.config.getReaderIdleTimeSeconds());
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        int sessions = TsiSessionManager.getInstance().add();
        log.info("{}.++channelActive: {}, {} Sessions.", new Object[]{this.getClass().getSimpleName(), NettyUtils.getAddress((Channel)ctx.channel()), sessions});
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        TsiNodeVo nodeVo = TsiSessionManager.getInstance().getNodeVo(ctx.channel());
        if (nodeVo != null) {
            nodeVo.setConnect(null);
            TsiSessionManager.getInstance().removeChannel(ctx.channel());
            NodeStatusVo status = new NodeStatusVo(1);
            status.setNodeId(nodeVo.getNodeId());
            status.setStatus(0);
            status.setIpAddr(NettyUtils.getRemoteIpAddress((Channel)ctx.channel()));
            if (TsiSessionManager.getInstance().isServerRun()) {
                TsiCpuDisconnected packet = new TsiCpuDisconnected(nodeVo.getNodeId(), ctx.channel());
                packet.setBuf(null);
                packet.setObj((Object)nodeVo);
                this.tsiCvimPacketService.add((Object)packet, (int)Thread.currentThread().getId());
                this.tsiCvimDbmsService.add((Object)status, (int)Thread.currentThread().getId());
            } else {
                log.error("Node Logout but server not running: {}", (Object)status.toString());
            }
            log.error("{}.channelInactive: Node Channel close: {}, {}", new Object[]{this.getClass().getSimpleName(), nodeVo.getNodeId(), ctx.channel()});
        }
        ctx.channel().attr(TsiSessionManager.TSI_NODE_ATTRIBUTE_KEY).set(null);
        int sessions = TsiSessionManager.getInstance().remove();
        log.info("{}.channelInactive: {}, {} Sessions.", new Object[]{this.getClass().getSimpleName(), NettyUtils.getAddress((Channel)ctx.channel()), sessions});
        super.channelInactive(ctx);
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        log.error("channelIdle: {}", (Object)evt.toString());
        TsiNodeVo nodeVo = TsiSessionManager.getInstance().getNodeVo(ctx.channel());
        if (nodeVo != null) {
            log.error("{}.channelIdle: {}, {}, {}", new Object[]{this.getClass().getSimpleName(), nodeVo.getNodeId(), ctx.channel(), evt.state().toString()});
        }
        if (evt.state() == IdleState.READER_IDLE) {
            log.error("{}.channelIdle: READER_IDLE: {}", (Object)this.getClass().getSimpleName(), (Object)NettyUtils.getAddress((Channel)ctx.channel()));
            if (nodeVo == null) {
                if (TsiAlarmManager.getInstance().checkAlarm(TsiAlarmConfigVo.COMM_02)) {
                    AlarmOccrVo alarm = new AlarmOccrVo(4);
                    alarm.setAlarmCode(TsiAlarmConfigVo.COMM_02);
                    alarm.setAlarmTarget(NettyUtils.getRemoteIpAddress((Channel)ctx.channel()));
                    alarm.setAlarmValue(NettyUtils.getRemoteIpAddress((Channel)ctx.channel()));
                    this.tsiCvimDbmsService.add((Object)alarm, (int)Thread.currentThread().getId());
                    log.warn("Recv Timeout: {}", (Object)NettyUtils.getRemoteIpAddress((Channel)ctx.channel()));
                }
                ctx.channel().close();
            }
        } else if (evt.state() == IdleState.WRITER_IDLE) {
            log.error("{}.channelIdle: WRITER_IDLE: {}", (Object)this.getClass().getSimpleName(), (Object)NettyUtils.getAddress((Channel)ctx.channel()));
        } else if (evt.state() == IdleState.ALL_IDLE) {
            log.error("{}.channelIdle: ALL_IDLE: {}", (Object)this.getClass().getSimpleName(), (Object)NettyUtils.getAddress((Channel)ctx.channel()));
        }
        super.channelIdle(ctx, evt);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        TsiNodeVo nodeVo = TsiSessionManager.getInstance().getNodeVo(ctx.channel());
        if (nodeVo != null) {
            log.error("{}.exceptionCaught: {}, {}", new Object[]{this.getClass().getSimpleName(), nodeVo.getNodeId(), ctx.channel()});
        }
        log.error("{}.exceptionCaught: {}", (Object)this.getClass().getSimpleName(), (Object)NettyUtils.getAddress((Channel)ctx.channel()));
        super.exceptionCaught(ctx, cause);
        ctx.channel().close();
    }
}

