/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server;

import com.tsi.app.common.app.AppUtils;
import com.tsi.comm.server.kafka.KafkaConsumerService;
import com.tsi.comm.server.kafka.KafkaProducerService;
import com.tsi.comm.server.mybatis.TsiDatabaseService;
import com.tsi.comm.server.mybatis.vo.AlarmOccrVo;
import com.tsi.comm.server.repository.TsiAlarmManager;
import com.tsi.comm.server.repository.TsiSessionManager;
import com.tsi.comm.server.tcp.TsiCvimServer;
import com.tsi.comm.server.vo.TsiAlarmConfigVo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@EnableTransactionManagement
@ComponentScan(basePackages={"com.tsi.app.common", "com.tsi.comm.server.config", "com.tsi.comm.server"})
public class TsiCommServerApplication
implements CommandLineRunner,
ApplicationListener<ContextClosedEvent>,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TsiCommServerApplication.class);
    private static String applicationName = "tsi-comm-server";

    public static void main(String[] args) {
        SpringApplication application = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{TsiCommServerApplication.class}).listeners(new ApplicationListener[]{new ApplicationPidFileWriter("./conf/" + applicationName + ".pid")}).build();
        application.setBannerMode(Banner.Mode.OFF);
        application.run(args);
    }

    public void run(String ... args) throws Exception {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.info("");
        log.info("");
        log.info("************************************************************************************");
        log.info("**                                                                                **");
        log.info("**                               TSI CVIM System                                  **");
        log.info("**                      CVIM Communication Server Program.                        **");
        log.info("**                                                                                **");
        log.info("**                                                                   [ver.1.0]    **");
        log.info("** startup: {}", (Object)sdfDate.format(new Date()));
        log.info("************************************************************************************");
        TsiAlarmManager.getInstance().getProcessStateVo().setProcessId(applicationName);
        TsiSessionManager.getInstance().start();
        TsiCvimServer cvimServer = (TsiCvimServer)AppUtils.getBean(TsiCvimServer.class);
        cvimServer.run();
        KafkaConsumerService kafkaConsumerService = (KafkaConsumerService)AppUtils.getBean(KafkaConsumerService.class);
        kafkaConsumerService.start();
        try {
            TsiDatabaseService tsiDatabaseService = (TsiDatabaseService)AppUtils.getBean(TsiDatabaseService.class);
            AlarmOccrVo alarm = new AlarmOccrVo(4);
            alarm.setAlarmCode(TsiAlarmConfigVo.SYS_00);
            alarm.setAlarmTarget(applicationName);
            alarm.setAlarmValue("Running");
            tsiDatabaseService.insertAlarmOccrHs(alarm);
            tsiDatabaseService.updateProcessState(0);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void onApplicationEvent(ContextClosedEvent contextClosedEvent) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        TsiSessionManager.getInstance().stop();
        TsiCvimServer cvimServer = (TsiCvimServer)AppUtils.getBean(TsiCvimServer.class);
        try {
            cvimServer.stop();
        }
        catch (Exception e) {
            // empty catch block
        }
        KafkaProducerService kafkaProducerService = (KafkaProducerService)AppUtils.getBean(KafkaProducerService.class);
        try {
            kafkaProducerService.shutdown();
        }
        catch (Exception e) {
            // empty catch block
        }
        TsiDatabaseService tsiDatabaseService = (TsiDatabaseService)AppUtils.getBean(TsiDatabaseService.class);
        try {
            tsiDatabaseService.updateNodeStatusTerm();
            AlarmOccrVo alarm = new AlarmOccrVo(4);
            alarm.setAlarmCode(TsiAlarmConfigVo.SYS_00);
            alarm.setAlarmTarget(applicationName);
            alarm.setAlarmValue("Terminated");
            tsiDatabaseService.insertAlarmOccrHs(alarm);
            tsiDatabaseService.updateProcessState(2);
        }
        catch (Exception e) {
            // empty catch block
        }
        log.error("Application Terminated: {}, {}", (Object)sdfDate.format(new Date()), (Object)contextClosedEvent.toString());
    }

    public void destroy() throws Exception {
    }

    public void afterPropertiesSet() throws Exception {
    }
}

