/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.mongo.dto;

import com.tsi.app.common.cpu.dto.TsiCvimAbnormal;
import com.tsi.app.common.cpu.dto.TsiCvimControl;
import com.tsi.app.common.cpu.dto.TsiCvimStatus;
import com.tsi.app.common.utils.StringUtils;
import com.tsi.comm.server.mongo.dto.TcsNodeStatus;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

@Document(collection="tb_tcs_node_status")
public class TcsNodeStatus {
    @Id
    private Long _id;
    private Long nodeId;
    private boolean isConnect;
    private String collectTime;
    private String tscDateTime;
    private int cycleElapsedTime;
    private TsiCvimControl tscControlInfo = new TsiCvimControl();
    private TsiCvimAbnormal tscAbnormalInfo = new TsiCvimAbnormal();
    private int signalStatusInfoCount;
    private List<TsiCvimStatus> signalStatusInfos = new ArrayList();

    public TcsNodeStatus(Long _id, Long nodeId, boolean isConnect, String collectTime, String tscDateTime, int cycleElapsedTime, TsiCvimControl tscControlInfo, TsiCvimAbnormal tscAbnormalInfo, int signalStatusInfoCount, List<TsiCvimStatus> signalStatusInfos) {
        this._id = _id;
        this.nodeId = nodeId;
        this.isConnect = isConnect;
        this.collectTime = collectTime;
        this.tscDateTime = tscDateTime;
        this.cycleElapsedTime = cycleElapsedTime;
        this.tscControlInfo = tscControlInfo;
        this.tscAbnormalInfo = tscAbnormalInfo;
        this.signalStatusInfoCount = signalStatusInfoCount;
        this.signalStatusInfos = signalStatusInfos;
    }

    private String toValue(String connect) {
        return this.nodeId + "," + connect + "," + this.collectTime + "," + this.tscDateTime + "," + this.cycleElapsedTime + "," + this.signalStatusInfoCount;
    }

    public String toDataString() {
        String connect = StringUtils.getString((boolean)this.isConnect);
        if (this.isConnect) {
            String statusValue = "";
            for (TsiCvimStatus status : this.signalStatusInfos) {
                statusValue = statusValue + status.toDataString() + "|";
            }
            return this.toValue(connect) + "^" + this.tscControlInfo.toDataString() + "^" + this.tscAbnormalInfo.toDataString() + "^" + statusValue;
        }
        return this.nodeId + "," + connect;
    }

    public static TcsNodeStatusBuilder builder() {
        return new TcsNodeStatusBuilder();
    }

    public Long get_id() {
        return this._id;
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public boolean isConnect() {
        return this.isConnect;
    }

    public String getCollectTime() {
        return this.collectTime;
    }

    public String getTscDateTime() {
        return this.tscDateTime;
    }

    public int getCycleElapsedTime() {
        return this.cycleElapsedTime;
    }

    public TsiCvimControl getTscControlInfo() {
        return this.tscControlInfo;
    }

    public TsiCvimAbnormal getTscAbnormalInfo() {
        return this.tscAbnormalInfo;
    }

    public int getSignalStatusInfoCount() {
        return this.signalStatusInfoCount;
    }

    public List<TsiCvimStatus> getSignalStatusInfos() {
        return this.signalStatusInfos;
    }

    public String toString() {
        return "TcsNodeStatus(_id=" + this.get_id() + ", nodeId=" + this.getNodeId() + ", isConnect=" + this.isConnect() + ", collectTime=" + this.getCollectTime() + ", tscDateTime=" + this.getTscDateTime() + ", cycleElapsedTime=" + this.getCycleElapsedTime() + ", tscControlInfo=" + this.getTscControlInfo() + ", tscAbnormalInfo=" + this.getTscAbnormalInfo() + ", signalStatusInfoCount=" + this.getSignalStatusInfoCount() + ", signalStatusInfos=" + this.getSignalStatusInfos() + ")";
    }
}

