/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.config;

import com.tsi.app.common.xnet.NetUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="application.kafka.producer")
public class TsiKafkaProducerConfig {
    private static final Logger log = LoggerFactory.getLogger(TsiKafkaProducerConfig.class);
    public static final String CVIM_RAW_TOPIC = "cvim-raw";
    public static final String TEST_TOPIC = "topic-for-ssd-test";
    public static final String CVIM_PING = "cvim_ping";
    private String consumerGroupId = "tsi-comm-server";
    private String consumerAckConfig = "1";
    private boolean multiConnect = false;
    private String bootstrapServers;
    public List<Map<String, String>> props = new ArrayList();
    private String cvimServers = "";
    private String nodeServers = "";
    private String testServers = "";
    private boolean enableCvim = true;
    private boolean enableNode = true;
    private boolean enableTest = true;

    @PostConstruct
    private void init() {
        if (this.cvimServers.equals("")) {
            this.cvimServers = this.bootstrapServers;
        }
        if (this.nodeServers.equals("")) {
            this.nodeServers = this.bootstrapServers;
        }
        if (this.testServers.equals("")) {
            this.testServers = this.bootstrapServers;
        }
        log.info("[{}] --------------------", (Object)this.getClass().getSimpleName());
        log.info("[{}]     multiConnect: {}", (Object)this.getClass().getSimpleName(), (Object)this.multiConnect);
        log.info("[{}] bootstrapServers: {}", (Object)this.getClass().getSimpleName(), (Object)this.bootstrapServers);
        log.info("[{}]            props: {}", (Object)this.getClass().getSimpleName(), (Object)this.props.toArray());
        log.info("[{}]      cvimServers: {}", (Object)this.getClass().getSimpleName(), (Object)this.cvimServers);
        log.info("[{}]      nodeServers: {}", (Object)this.getClass().getSimpleName(), (Object)this.nodeServers);
        log.info("[{}]      testServers: {}", (Object)this.getClass().getSimpleName(), (Object)this.testServers);
        log.info("[{}]       enableCvim: {}", (Object)this.getClass().getSimpleName(), (Object)this.enableCvim);
        log.info("[{}]       enableNode: {}", (Object)this.getClass().getSimpleName(), (Object)this.enableNode);
        log.info("[{}]       enableTest: {}", (Object)this.getClass().getSimpleName(), (Object)this.enableTest);
    }

    public String getGroupId() {
        return this.consumerGroupId + "-" + NetUtils.getHostName();
    }

    public Map<String, Object> getConsumerPropertiesMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("bootstrap.servers", this.bootstrapServers);
        properties.put("group.id", this.getGroupId());
        properties.put("enable.auto.commit", "true");
        properties.put("auto.commit.interval.ms", 1);
        properties.put("session.timeout.ms", "10000");
        properties.put("auto.offset.reset", "latest");
        properties.put("max.poll.interval.ms", "100");
        properties.put("check.crcs", false);
        properties.put("max.poll.records", 1);
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", LongDeserializer.class);
        return properties;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public String getConsumerAckConfig() {
        return this.consumerAckConfig;
    }

    public boolean isMultiConnect() {
        return this.multiConnect;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public List<Map<String, String>> getProps() {
        return this.props;
    }

    public String getCvimServers() {
        return this.cvimServers;
    }

    public String getNodeServers() {
        return this.nodeServers;
    }

    public String getTestServers() {
        return this.testServers;
    }

    public boolean isEnableCvim() {
        return this.enableCvim;
    }

    public boolean isEnableNode() {
        return this.enableNode;
    }

    public boolean isEnableTest() {
        return this.enableTest;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    public void setConsumerAckConfig(String consumerAckConfig) {
        this.consumerAckConfig = consumerAckConfig;
    }

    public void setMultiConnect(boolean multiConnect) {
        this.multiConnect = multiConnect;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public void setProps(List<Map<String, String>> props) {
        this.props = props;
    }

    public void setCvimServers(String cvimServers) {
        this.cvimServers = cvimServers;
    }

    public void setNodeServers(String nodeServers) {
        this.nodeServers = nodeServers;
    }

    public void setTestServers(String testServers) {
        this.testServers = testServers;
    }

    public void setEnableCvim(boolean enableCvim) {
        this.enableCvim = enableCvim;
    }

    public void setEnableNode(boolean enableNode) {
        this.enableNode = enableNode;
    }

    public void setEnableTest(boolean enableTest) {
        this.enableTest = enableTest;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsiKafkaProducerConfig)) {
            return false;
        }
        TsiKafkaProducerConfig other = (TsiKafkaProducerConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isMultiConnect() != other.isMultiConnect()) {
            return false;
        }
        if (this.isEnableCvim() != other.isEnableCvim()) {
            return false;
        }
        if (this.isEnableNode() != other.isEnableNode()) {
            return false;
        }
        if (this.isEnableTest() != other.isEnableTest()) {
            return false;
        }
        String this$consumerGroupId = this.getConsumerGroupId();
        String other$consumerGroupId = other.getConsumerGroupId();
        if (this$consumerGroupId == null ? other$consumerGroupId != null : !this$consumerGroupId.equals(other$consumerGroupId)) {
            return false;
        }
        String this$consumerAckConfig = this.getConsumerAckConfig();
        String other$consumerAckConfig = other.getConsumerAckConfig();
        if (this$consumerAckConfig == null ? other$consumerAckConfig != null : !this$consumerAckConfig.equals(other$consumerAckConfig)) {
            return false;
        }
        String this$bootstrapServers = this.getBootstrapServers();
        String other$bootstrapServers = other.getBootstrapServers();
        if (this$bootstrapServers == null ? other$bootstrapServers != null : !this$bootstrapServers.equals(other$bootstrapServers)) {
            return false;
        }
        List this$props = this.getProps();
        List other$props = other.getProps();
        if (this$props == null ? other$props != null : !((Object)this$props).equals(other$props)) {
            return false;
        }
        String this$cvimServers = this.getCvimServers();
        String other$cvimServers = other.getCvimServers();
        if (this$cvimServers == null ? other$cvimServers != null : !this$cvimServers.equals(other$cvimServers)) {
            return false;
        }
        String this$nodeServers = this.getNodeServers();
        String other$nodeServers = other.getNodeServers();
        if (this$nodeServers == null ? other$nodeServers != null : !this$nodeServers.equals(other$nodeServers)) {
            return false;
        }
        String this$testServers = this.getTestServers();
        String other$testServers = other.getTestServers();
        return !(this$testServers == null ? other$testServers != null : !this$testServers.equals(other$testServers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TsiKafkaProducerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMultiConnect() ? 79 : 97);
        result = result * 59 + (this.isEnableCvim() ? 79 : 97);
        result = result * 59 + (this.isEnableNode() ? 79 : 97);
        result = result * 59 + (this.isEnableTest() ? 79 : 97);
        String $consumerGroupId = this.getConsumerGroupId();
        result = result * 59 + ($consumerGroupId == null ? 43 : $consumerGroupId.hashCode());
        String $consumerAckConfig = this.getConsumerAckConfig();
        result = result * 59 + ($consumerAckConfig == null ? 43 : $consumerAckConfig.hashCode());
        String $bootstrapServers = this.getBootstrapServers();
        result = result * 59 + ($bootstrapServers == null ? 43 : $bootstrapServers.hashCode());
        List $props = this.getProps();
        result = result * 59 + ($props == null ? 43 : ((Object)$props).hashCode());
        String $cvimServers = this.getCvimServers();
        result = result * 59 + ($cvimServers == null ? 43 : $cvimServers.hashCode());
        String $nodeServers = this.getNodeServers();
        result = result * 59 + ($nodeServers == null ? 43 : $nodeServers.hashCode());
        String $testServers = this.getTestServers();
        result = result * 59 + ($testServers == null ? 43 : $testServers.hashCode());
        return result;
    }

    public String toString() {
        return "TsiKafkaProducerConfig(consumerGroupId=" + this.getConsumerGroupId() + ", consumerAckConfig=" + this.getConsumerAckConfig() + ", multiConnect=" + this.isMultiConnect() + ", bootstrapServers=" + this.getBootstrapServers() + ", props=" + this.getProps() + ", cvimServers=" + this.getCvimServers() + ", nodeServers=" + this.getNodeServers() + ", testServers=" + this.getTestServers() + ", enableCvim=" + this.isEnableCvim() + ", enableNode=" + this.isEnableNode() + ", enableTest=" + this.isEnableTest() + ")";
    }
}

