/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.protocol;

import com.tsi.app.common.cpu.enums.eOpCode;
import com.tsi.app.common.utils.ByteUtils;
import com.tsi.app.common.utils.TimeUtils;
import com.tsi.app.common.xnet.NettyUtils;
import com.tsi.comm.server.protocol.TsiCpuAddPacket;
import com.tsi.comm.server.protocol.TsiCpuPacket;
import com.tsi.comm.server.repository.TsiNodeAddManager;
import com.tsi.comm.server.vo.TsiNodeAddDetailVo;
import com.tsi.comm.server.vo.TsiNodeAddVo;
import com.tsi.comm.server.vo.TsiNodeVo;
import io.netty.channel.Channel;

public class TsiCpuDisconnected
extends TsiCpuPacket {
    public TsiCpuDisconnected(long nodeId, Channel channel) {
        this(nodeId, TimeUtils.currentTimeSeconds(), System.nanoTime(), channel);
    }

    public TsiCpuDisconnected(long nodeId, long msec, long nsec, Channel channel) {
        super(nodeId, msec, nsec, NettyUtils.getRemoteIpAddressToLong((Channel)channel), NettyUtils.getRemotePort((Channel)channel));
        this.setOpCode(eOpCode.TSI_CPU_DISCONNECTED.getValue());
    }

    protected void makeAddNodeCvimPaket(TsiCpuPacket cpuPacket) {
        int headSize = 27;
        cpuPacket.cvimData = new byte[27];
        System.arraycopy(this.timespec.bytes(), 0, cpuPacket.cvimData, 0, 16);
        ByteUtils.setUnsignedInt((byte[])cpuPacket.cvimData, (int)16, (long)this.getRemoteIp());
        ByteUtils.setUnsignedShort((byte[])cpuPacket.cvimData, (int)20, (int)this.getRemotePort());
        cpuPacket.cvimData[22] = 0;
        ByteUtils.setUnsignedInt((byte[])cpuPacket.cvimData, (int)23, (long)cpuPacket.nodeId);
    }

    public boolean parsing(TsiNodeVo obj) {
        TsiNodeAddVo tsiNodeAddVo = TsiNodeAddManager.getInstance().get(this.nodeId);
        if (tsiNodeAddVo == null) {
            this.makeCvimPacket();
            return true;
        }
        for (Integer key : tsiNodeAddVo.getAddNodeMap().keySet()) {
            TsiNodeAddDetailVo detailVo = (TsiNodeAddDetailVo)tsiNodeAddVo.getAddNodeMap().get(key);
            TsiCpuAddPacket addPacket = new TsiCpuAddPacket(detailVo.getNodeId(), this.timespec, this.remoteIp, this.remotePort);
            this.makeAddNodeCvimPaket((TsiCpuPacket)addPacket);
            this.addNodes.add(addPacket);
        }
        return true;
    }
}

