/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.config;

import com.tsi.app.common.xnet.NettyServerConfig;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="application.cvim-server")
public class TsiCvimServerConfig
extends NettyServerConfig {
    private static final Logger log = LoggerFactory.getLogger(TsiCvimServerConfig.class);
    private int maxConnection = 0;
    private boolean loggingThread = false;
    private int packetWorkers = 0;
    private int loggingWorkers = 0;
    private int dbmsWorkers = 0;

    @PostConstruct
    private void init() {
        this.configure();
        if (this.maxConnection == 0) {
            this.maxConnection = 10000;
        }
        if (this.packetWorkers == 0) {
            this.packetWorkers = Runtime.getRuntime().availableProcessors() / 2;
            if (this.packetWorkers == 0) {
                this.packetWorkers = 1;
            }
        }
        if (this.loggingWorkers == 0) {
            this.loggingWorkers = Runtime.getRuntime().availableProcessors() / 4;
            if (this.loggingWorkers == 0) {
                this.loggingWorkers = 1;
            }
        }
        if (this.dbmsWorkers == 0) {
            this.dbmsWorkers = Runtime.getRuntime().availableProcessors() / 4;
            if (this.dbmsWorkers == 0) {
                this.dbmsWorkers = 1;
            }
        }
        if (this.getReaderIdleTimeSeconds() <= 5) {
            this.setReaderIdleTimeSeconds(5);
        }
        log.info("[{}] -------------------------", (Object)this.getClass().getSimpleName());
        log.info("[{}]         maxConnection: {}", (Object)this.getClass().getSimpleName(), (Object)this.maxConnection);
        log.info("[{}]         loggingThread: {}", (Object)this.getClass().getSimpleName(), (Object)this.loggingThread);
        log.info("[{}]         packetWorkers: {}", (Object)this.getClass().getSimpleName(), (Object)this.packetWorkers);
        log.info("[{}]        loggingWorkers: {}", (Object)this.getClass().getSimpleName(), (Object)this.loggingWorkers);
        log.info("{}", (Object)super.toString());
    }

    public int getQueueSize() {
        int qSize = 10000;
        if (this.maxConnection == 0) {
            qSize = 10000;
        } else if (this.maxConnection < 5000) {
            qSize = 5000;
        } else if (this.maxConnection > qSize) {
            qSize = this.maxConnection;
        }
        return qSize;
    }

    public int getMaxConnection() {
        return this.maxConnection;
    }

    public boolean isLoggingThread() {
        return this.loggingThread;
    }

    public int getPacketWorkers() {
        return this.packetWorkers;
    }

    public int getLoggingWorkers() {
        return this.loggingWorkers;
    }

    public int getDbmsWorkers() {
        return this.dbmsWorkers;
    }

    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    public void setLoggingThread(boolean loggingThread) {
        this.loggingThread = loggingThread;
    }

    public void setPacketWorkers(int packetWorkers) {
        this.packetWorkers = packetWorkers;
    }

    public void setLoggingWorkers(int loggingWorkers) {
        this.loggingWorkers = loggingWorkers;
    }

    public void setDbmsWorkers(int dbmsWorkers) {
        this.dbmsWorkers = dbmsWorkers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsiCvimServerConfig)) {
            return false;
        }
        TsiCvimServerConfig other = (TsiCvimServerConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getMaxConnection() != other.getMaxConnection()) {
            return false;
        }
        if (this.isLoggingThread() != other.isLoggingThread()) {
            return false;
        }
        if (this.getPacketWorkers() != other.getPacketWorkers()) {
            return false;
        }
        if (this.getLoggingWorkers() != other.getLoggingWorkers()) {
            return false;
        }
        return this.getDbmsWorkers() == other.getDbmsWorkers();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TsiCvimServerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxConnection();
        result = result * 59 + (this.isLoggingThread() ? 79 : 97);
        result = result * 59 + this.getPacketWorkers();
        result = result * 59 + this.getLoggingWorkers();
        result = result * 59 + this.getDbmsWorkers();
        return result;
    }

    public String toString() {
        return "TsiCvimServerConfig(maxConnection=" + this.getMaxConnection() + ", loggingThread=" + this.isLoggingThread() + ", packetWorkers=" + this.getPacketWorkers() + ", loggingWorkers=" + this.getLoggingWorkers() + ", dbmsWorkers=" + this.getDbmsWorkers() + ")";
    }
}

