/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.process.packet;

import com.tsi.app.common.app.AppUtils;
import com.tsi.app.common.cpu.enums.eOpCode;
import com.tsi.app.common.utils.TimeUtils;
import com.tsi.comm.server.kafka.KafkaProducerService;
import com.tsi.comm.server.mongo.repository.TsiNodeStatusRepository;
import com.tsi.comm.server.process.AbstractTsiCvimWorker;
import com.tsi.comm.server.process.logging.TsiCvimLoggingProcess;
import com.tsi.comm.server.protocol.AbstractTsiPacket;
import com.tsi.comm.server.protocol.TsiCpuAddPacket;
import com.tsi.comm.server.protocol.TsiCpuDisconnected;
import com.tsi.comm.server.protocol.TsiCpuPacket;
import com.tsi.comm.server.vo.TsiNodeVo;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TsiCvimPacketWorker
extends AbstractTsiCvimWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TsiCvimPacketWorker.class);
    private final LinkedBlockingQueue<AbstractTsiPacket> DATA_QUEUE;
    private final KafkaProducerService kafkaProducer;
    private final TsiCvimLoggingProcess loggingService;
    private TsiNodeStatusRepository tsiNodeStatusRepository;

    public TsiCvimPacketWorker(int idx, int qSize, KafkaProducerService kafkaProducer) {
        this.idx = idx;
        this.qSize = qSize;
        this.kafkaProducer = kafkaProducer;
        this.loggingService = (TsiCvimLoggingProcess)AppUtils.getBean(TsiCvimLoggingProcess.class);
        this.DATA_QUEUE = new LinkedBlockingQueue(qSize);
        try {
            this.tsiNodeStatusRepository = (TsiNodeStatusRepository)AppUtils.getBean(TsiNodeStatusRepository.class);
        }
        catch (Exception e) {
            this.tsiNodeStatusRepository = null;
            log.error("MongoDB: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void run() {
        log.info("{} Start. QSIZE: {}", (Object)Thread.currentThread().getName(), (Object)this.qSize);
        while (true) {
            try {
                while (true) {
                    Object packet;
                    if ((packet = this.DATA_QUEUE.take()) != null) {
                        this.process(packet);
                        continue;
                    }
                    Thread.yield();
                }
            }
            catch (Exception e) {
                log.error("Exception: {}", (Object)e.getMessage());
                continue;
            }
            break;
        }
    }

    public boolean add(Object object) {
        boolean offer = false;
        AbstractTsiPacket packet = (AbstractTsiPacket)object;
        try {
            offer = this.DATA_QUEUE.offer(packet);
            if (!offer) {
                MDC.put((String)"id", (String)Long.toString(packet.getNodeId()));
                log.error("Packet Queue.offer: {}/{}, Queue Full: {} EA, {}, {}", new Object[]{packet.getNodeId(), this.DATA_QUEUE.size(), this.qSize, TimeUtils.elapsedTime((long)packet.getRcv()), Thread.currentThread().getName()});
                MDC.clear();
            }
        }
        catch (Exception e) {
            MDC.put((String)"id", (String)Long.toString(packet.getNodeId()));
            log.error("Packet Queue.offer: Exception: {}, {}, {}", new Object[]{packet.getNodeId(), Thread.currentThread().getName(), e.getMessage()});
            MDC.clear();
        }
        return offer;
    }

    public void process(Object object) {
        int ii;
        AbstractTsiPacket packet = (AbstractTsiPacket)object;
        TsiCpuPacket cpuPacket = (TsiCpuPacket)packet;
        TsiNodeVo nodeVo = (TsiNodeVo)cpuPacket.getObj();
        long curr = System.nanoTime();
        if (TimeUnit.MILLISECONDS.convert(curr - packet.getRcv(), TimeUnit.NANOSECONDS) > 3000L) {
            log.error("Packet skip::: {}, {} ms.", (Object)packet.getNodeId(), (Object)TimeUnit.MILLISECONDS.convert(curr - packet.getRcv(), TimeUnit.NANOSECONDS));
            return;
        }
        packet.setPop(curr);
        if (packet.getOpCode() == (byte)eOpCode.TSI_CPU_DISCONNECTED.getValue()) {
            TsiCpuDisconnected disconnected = (TsiCpuDisconnected)packet;
            disconnected.parsing(nodeVo);
            if (nodeVo != null) {
                if (nodeVo.isSendCvim() && disconnected.getCvimData() != null) {
                    this.kafkaProducer.sendCvim(disconnected.getNodeId(), disconnected.getCvimData());
                }
                if (disconnected.getAddNodes() != null) {
                    for (int ii2 = 0; ii2 < disconnected.getAddNodes().size(); ++ii2) {
                        this.kafkaProducer.sendCvim(((TsiCpuAddPacket)disconnected.getAddNodes().get(ii2)).getNodeId(), ((TsiCpuAddPacket)disconnected.getAddNodes().get(ii2)).getCvimData());
                    }
                }
                this.loggingService.add((Object)packet, this.idx);
            }
            return;
        }
        if (!cpuPacket.parsing(nodeVo)) {
            MDC.put((String)"id", (String)nodeVo.getKey());
            log.error("Packet parsing failed: {}", (Object)packet.getNodeId());
            MDC.clear();
        }
        packet.setPar(System.nanoTime());
        if (nodeVo != null) {
            if (nodeVo.isSendNode() && packet.getNodeData() != null) {
                this.kafkaProducer.sendNode(Long.toString(packet.getNodeId()), packet.getNodeData());
            }
            if (nodeVo.isSendTest()) {
                this.kafkaProducer.sendTest(packet.getNodeId(), packet.getTestData());
            }
            if (nodeVo.isSendCvim() && packet.getCvimData() != null) {
                this.kafkaProducer.sendCvim(packet.getNodeId(), packet.getCvimData());
            }
            if (cpuPacket.getAddNodes() != null) {
                for (ii = 0; ii < cpuPacket.getAddNodes().size(); ++ii) {
                    if (nodeVo.isSendNode()) {
                        this.kafkaProducer.sendNode(Long.toString(((TsiCpuAddPacket)cpuPacket.getAddNodes().get(ii)).getNodeId()), ((TsiCpuAddPacket)cpuPacket.getAddNodes().get(ii)).getNodeData());
                    }
                    if (!nodeVo.isSendCvim()) continue;
                    this.kafkaProducer.sendCvim(((TsiCpuAddPacket)cpuPacket.getAddNodes().get(ii)).getNodeId(), ((TsiCpuAddPacket)cpuPacket.getAddNodes().get(ii)).getCvimData());
                }
            }
        } else {
            MDC.put((String)"id", (String)Long.toString(packet.getNodeId()));
            log.warn("Not found node object: {}", (Object)packet.getNodeId());
            MDC.clear();
            this.kafkaProducer.sendTest(packet.getNodeId(), packet.getTestData());
        }
        packet.setEnd(System.nanoTime());
        packet.setAvg(this.calcProcessTime(packet.getRcv()));
        this.loggingService.add((Object)packet, this.idx);
        if (cpuPacket.getAddNodes() != null) {
            for (ii = 0; ii < cpuPacket.getAddNodes().size(); ++ii) {
                ((TsiCpuAddPacket)cpuPacket.getAddNodes().get(ii)).setAdd(packet.getAdd());
                ((TsiCpuAddPacket)cpuPacket.getAddNodes().get(ii)).setPop(packet.getPop());
                ((TsiCpuAddPacket)cpuPacket.getAddNodes().get(ii)).setPar(packet.getPar());
                ((TsiCpuAddPacket)cpuPacket.getAddNodes().get(ii)).setEnd(packet.getEnd());
                ((TsiCpuAddPacket)cpuPacket.getAddNodes().get(ii)).setAvg(packet.getAvg());
                this.loggingService.add(cpuPacket.getAddNodes().get(ii), this.idx);
            }
        }
    }

    public void report() {
        long avgTime = 0L;
        log.info("Packet: Remain Q: {}, Average: {}, {}", new Object[]{this.DATA_QUEUE.size(), TimeUtils.elapsedTimeStr((long)avgTime), Thread.currentThread().getName()});
    }
}

