/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public class AppNameInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger log = LoggerFactory.getLogger(AppNameInitializer.class);

    public void initialize(ConfigurableApplicationContext context) {
        try {
            String applicationName = "";
            String poolName = "";
            ConfigurableEnvironment env = context.getEnvironment();
            String appName = env.getProperty("spring.application.name", "tsi-comm-server");
            String serverId = env.getProperty("application.cvim-server.server-id", "0");
            applicationName = appName + "-" + serverId;
            poolName = "pool-" + appName + "-" + serverId;
            System.setProperty("spring.application.name", applicationName);
            System.setProperty("spring.datasource.hikari.pool-name", poolName);
        }
        catch (Exception e) {
            log.error("Error during context initialization: {}", (Object)e.getMessage());
        }
    }
}

