/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server;

import com.tsi.comm.server.config.ApplicationConfig;
import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.kafka.KafkaConsumerService;
import com.tsi.comm.server.kafka.KafkaProducerService;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.process.logging.TsiCvimLoggingProcess;
import com.tsi.comm.server.process.packet.TsiCvimPacketProcess;
import com.tsi.comm.server.repository.ApplicationRepository;
import com.tsi.comm.server.service.TsiCommServerService;
import com.tsi.comm.server.tcp.TsiCvimServer;
import com.tsi.comm.server.vo.TsiAlarmConfigVo;
import com.tsi.comm.server.vo.mariadb.AlarmOccrVo;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationLifecycle {
    private static final Logger log = LoggerFactory.getLogger(ApplicationLifecycle.class);
    private final ApplicationConfig applicationConfig;
    private final TsiCvimServerConfig serverConfig;
    private final TsiCommServerService tsiCommServerService;
    private final KafkaConsumerService kafkaConsumerService;
    private final KafkaProducerService kafkaProducerService;
    private final TsiCvimPacketProcess packetProcess;
    private final TsiCvimLoggingProcess loggingProcess;
    private final TsiCvimDbmsProcess dbmsProcess;
    private final TsiCvimServer cvimServer;
    private String applicationName;
    private int serverId = 0;

    @PostConstruct
    public void start() {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.info("");
        log.info("************************************************************************************");
        log.info("**                                 TSI CVIM System                                **");
        log.info("**                      CVIM Communication Server Program.                        **");
        log.info("**                                                                   [ver.1.0]    **");
        log.info("** startup: {}", (Object)sdfDate.format(new Date()));
        log.info("************************************************************************************");
        this.applicationConfig.setStartSchedule(false);
        this.serverId = this.serverConfig.getServerId();
        this.applicationName = "tsi-comm-server-" + this.serverConfig.getServerId();
        ApplicationRepository.processStateVo.setProcessId(this.applicationName);
        this.tsiCommServerService.init();
        this.kafkaConsumerService.start();
        this.kafkaProducerService.start();
        this.packetProcess.start();
        this.loggingProcess.start();
        this.dbmsProcess.start();
        this.cvimServer.run();
        this.serverConfig.setStartup(true);
        try {
            AlarmOccrVo alarm = new AlarmOccrVo(4);
            alarm.setAlarmCode(TsiAlarmConfigVo.SYS_00);
            alarm.setAlarmTarget(this.applicationName);
            alarm.setAlarmValue("Running");
            this.tsiCommServerService.insertAlarmOccrHs(alarm);
            this.tsiCommServerService.updateProcessState(0);
        }
        catch (Exception e) {
            log.error("Error during startup alarm logging: {}", (Object)e.getMessage());
        }
        this.applicationConfig.setStartSchedule(true);
        log.info("Application has been started successfully.");
    }

    @PreDestroy
    public void stop() {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.error("************************************************************************************");
        log.error("**    Application Terminating: {}", (Object)sdfDate.format(new Date()));
        if (this.cvimServer != null) {
            this.cvimServer.stop();
            log.info("Netty Server stopped.");
        }
        if (this.kafkaConsumerService != null) {
            this.kafkaConsumerService.shutdown();
            log.info("Kafka Consumer stopped.");
        }
        if (this.packetProcess != null) {
            this.packetProcess.stop();
            log.info("Packet Process stopped.");
        }
        if (this.loggingProcess != null) {
            this.loggingProcess.stop();
            log.info("Logging Process stopped.");
        }
        if (this.dbmsProcess != null) {
            this.dbmsProcess.stop();
            log.info("DBMS Process stopped.");
        }
        if (this.kafkaProducerService != null) {
            this.kafkaProducerService.shutdown();
            log.info("Kafka Producer stopped.");
        }
        if (this.tsiCommServerService != null) {
            this.serverConfig.setStartup(false);
            int serverId = this.serverConfig.getServerId();
            this.tsiCommServerService.updateNodeStatusTerm(serverId);
            this.tsiCommServerService.updateProcessState(2);
            log.info("Final DB states updated.");
        }
        log.error("************************************************************************************");
    }

    public ApplicationLifecycle(ApplicationConfig applicationConfig, TsiCvimServerConfig serverConfig, TsiCommServerService tsiCommServerService, KafkaConsumerService kafkaConsumerService, KafkaProducerService kafkaProducerService, TsiCvimPacketProcess packetProcess, TsiCvimLoggingProcess loggingProcess, TsiCvimDbmsProcess dbmsProcess, TsiCvimServer cvimServer) {
        this.applicationConfig = applicationConfig;
        this.serverConfig = serverConfig;
        this.tsiCommServerService = tsiCommServerService;
        this.kafkaConsumerService = kafkaConsumerService;
        this.kafkaProducerService = kafkaProducerService;
        this.packetProcess = packetProcess;
        this.loggingProcess = loggingProcess;
        this.dbmsProcess = dbmsProcess;
        this.cvimServer = cvimServer;
    }
}

