/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.config;

import com.tsi.common.utils.TimeUtils;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="application")
public class ApplicationConfig {
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfig.class);
    private String processId = "tsi-comm-server";
    private boolean useLoggingThread = false;
    private double cpuLimits = 75.0;
    private String bootingTime;
    private boolean startSchedule;

    @PostConstruct
    private void init() {
        this.startSchedule = false;
        this.bootingTime = TimeUtils.now();
        if (this.cpuLimits < 50.0) {
            this.cpuLimits = 50.0;
        }
        if (this.cpuLimits > 90.0) {
            this.cpuLimits = 90.0;
        }
        MDC.put((String)"filename", (String)"config");
        log.info("[ApplicationConfig] -------------------------");
        log.info("[ApplicationConfig]         processId: {}", (Object)this.processId);
        log.info("[ApplicationConfig]  useLoggingThread: {}", (Object)this.useLoggingThread);
        log.info("[ApplicationConfig]         cpuLimits: {}", (Object)this.cpuLimits);
        MDC.clear();
    }

    public String getProcessId() {
        return this.processId;
    }

    public boolean isUseLoggingThread() {
        return this.useLoggingThread;
    }

    public double getCpuLimits() {
        return this.cpuLimits;
    }

    public String getBootingTime() {
        return this.bootingTime;
    }

    public boolean isStartSchedule() {
        return this.startSchedule;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public void setUseLoggingThread(boolean useLoggingThread) {
        this.useLoggingThread = useLoggingThread;
    }

    public void setCpuLimits(double cpuLimits) {
        this.cpuLimits = cpuLimits;
    }

    public void setBootingTime(String bootingTime) {
        this.bootingTime = bootingTime;
    }

    public void setStartSchedule(boolean startSchedule) {
        this.startSchedule = startSchedule;
    }

    public String toString() {
        return "ApplicationConfig(processId=" + this.getProcessId() + ", useLoggingThread=" + this.isUseLoggingThread() + ", cpuLimits=" + this.getCpuLimits() + ", bootingTime=" + this.getBootingTime() + ", startSchedule=" + this.isStartSchedule() + ")";
    }
}

