/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.config;

import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ThreadPoolInitializer
extends AsyncConfigurerSupport {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolInitializer.class);
    private int poolCore = 0;

    @PostConstruct
    private void init() {
        int MAX_CORE = Math.max(8, Runtime.getRuntime().availableProcessors());
        if (this.poolCore <= 0) {
            this.poolCore = MAX_CORE;
        }
        if (this.poolCore < MAX_CORE) {
            this.poolCore = MAX_CORE;
        }
        MDC.put((String)"filename", (String)"config");
        log.info("[ThreadPoolInitializer]   availableProcessors: {}", (Object)MAX_CORE);
        log.info("[ThreadPoolInitializer]        threadPoolCore: {}", (Object)this.poolCore);
        MDC.clear();
    }

    public ThreadPoolTaskExecutor getDefaultExecutor(int poolSize) {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(poolSize);
        threadPoolTaskExecutor.setMaxPoolSize(poolSize * 2);
        threadPoolTaskExecutor.setQueueCapacity(2000);
        return threadPoolTaskExecutor;
    }

    @Bean(name={"queueJobExecutor"})
    public Executor getQueueJobExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this.getDefaultExecutor(this.poolCore);
        threadPoolTaskExecutor.setThreadNamePrefix("tsi-queue-pool-");
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    @Bean(name={"dbmsJobExecutor"})
    public Executor getDbmsJobExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this.getDefaultExecutor(this.poolCore);
        threadPoolTaskExecutor.setThreadNamePrefix("tsi-dbms-pool-");
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    @NotNull
    public Executor getAsyncExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = this.getDefaultExecutor(this.poolCore * 2);
        threadPoolTaskExecutor.setThreadNamePrefix("tsi-async-pool-");
        threadPoolTaskExecutor.initialize();
        return threadPoolTaskExecutor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ThreadPoolInitializer)) {
            return false;
        }
        ThreadPoolInitializer other = (ThreadPoolInitializer)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getPoolCore() == other.getPoolCore();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ThreadPoolInitializer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPoolCore();
        return result;
    }

    public int getPoolCore() {
        return this.poolCore;
    }

    public void setPoolCore(int poolCore) {
        this.poolCore = poolCore;
    }

    public String toString() {
        return "ThreadPoolInitializer(poolCore=" + this.getPoolCore() + ")";
    }
}

