/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.controller;

import com.tsi.comm.server.config.ApplicationConfig;
import com.tsi.comm.server.config.TraceConfig;
import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.process.AbstractTsiCvimWorker;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsWorker;
import com.tsi.comm.server.process.logging.TsiCvimLoggingProcess;
import com.tsi.comm.server.process.logging.TsiCvimLoggingWorker;
import com.tsi.comm.server.process.packet.TsiCvimPacketProcess;
import com.tsi.comm.server.process.packet.TsiCvimPacketWorker;
import com.tsi.comm.server.repository.TsiAlarmManager;
import com.tsi.comm.server.repository.TsiNodeManager;
import com.tsi.comm.server.repository.TsiSessionManager;
import com.tsi.comm.server.vo.TsiNodeVo;
import com.tsi.comm.server.xnet.NettyUtils;
import com.tsi.common.utils.TimeUtils;
import io.netty.channel.Channel;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={""})
public class TsiCommServerRestController {
    private final ApplicationConfig config;
    private final TsiCvimServerConfig serverConfig;
    private final TraceConfig traceConfig;
    private final TsiNodeManager nodeManager;
    private final TsiSessionManager sessionManager;
    private final TsiAlarmManager alarmManager;
    private final TsiCvimPacketProcess packetProcess;
    private final TsiCvimLoggingProcess loggingProcess;
    private final TsiCvimDbmsProcess dbmsProcess;
    private final String sep = System.lineSeparator();
    private final String heading = "--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------";

    private StringBuilder getCommonHead() {
        StringBuilder sb = new StringBuilder();
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        sb.append(" UTIC TSI Wireless Communication Server").append(this.sep);
        sb.append(String.format(" Process Id: %s, Server Id: %d, Binding: %d, %s, %s", this.config.getProcessId(), this.serverConfig.getServerId(), this.serverConfig.getBindingPort(), this.config.getBootingTime(), TimeUtils.now())).append(this.sep);
        if (this.loggingProcess.isEnabled()) {
            sb.append(String.format(" Workers(Packet/Logging/Dbms): %d/%d/%d", this.serverConfig.getPacketWorkers(), this.serverConfig.getLoggingWorkers(), this.serverConfig.getDbmsWorkers())).append(this.sep);
        } else {
            sb.append(String.format(" Workers(Packet/Dbms): %d/%d", this.serverConfig.getPacketWorkers(), this.serverConfig.getDbmsWorkers())).append(this.sep);
        }
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        return sb;
    }

    @GetMapping(value={"/info"}, produces={"application/json; charset=utf8"})
    public String info() {
        int nodeCount = this.nodeManager.getTsiNodeVoMap().size();
        return this.infoNode(0, nodeCount, true);
    }

    @GetMapping(value={"/info-page"}, produces={"application/json; charset=utf8"})
    public String info(@RequestParam(value="page", defaultValue="0") int page, @RequestParam(value="size", defaultValue="100") int size) {
        return this.infoNode(page, size, false);
    }

    private String infoNode(int page, int size, boolean all) {
        StringBuilder sb = this.getCommonHead();
        int nodeCount = this.nodeManager.getTsiNodeVoMap().size();
        List allNodes = this.nodeManager.getTsiNodeVoMap().values().stream().sorted(Comparator.comparing(TsiNodeVo::getNodeId)).collect(Collectors.toList());
        int totalNodes = allNodes.size();
        int totalPages = (int)Math.ceil((double)totalNodes / (double)size);
        if (!all) {
            sb.append(String.format(" Report Node Sessions: %d Nodes. (Page %d / %d)", totalNodes, page + 1, totalPages)).append(this.sep);
        }
        sb.append(String.format(" Report Node Sessions: %d Nodes. A-INTCA(AddNode-Install/SendNode/SendTest/SendCvim)", nodeCount)).append(this.sep);
        List pagedNodes = allNodes.stream().skip((long)page * (long)size).limit(size).collect(Collectors.toList());
        int seqStart = page * size + 1;
        int registered = 0;
        int unknown = 0;
        int connected = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+9"));
        sb.append(String.format("   SEQ[U] %10s %4s %7s %19s %19s %9s %6s %19s  IP Address       Signal AvgTm(us)  Dropped/Overlapping Queue(P/L/D)", "Node ID", "A-INTC", "Connect", "Connect Time", "Disconnect Time", "Connected", "Closed", "Last-Recv-Time")).append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        for (TsiNodeVo node : pagedNodes) {
            String info;
            String connect;
            long avgTime;
            String check = node.isAddNodeEnabled() ? "Y-" : "N-";
            check = check + (node.isInstalled() ? "Y" : "N");
            check = check + (node.isSendNode() ? "Y" : "N");
            check = check + (node.isSendTest() ? "Y" : "N");
            check = check + (node.isSendCvim() ? "Y" : "N");
            String unknownNode = "   ";
            if (node.isRegistered()) {
                ++registered;
            } else {
                ++unknown;
                unknownNode = "***";
            }
            long l = avgTime = node.getSigCount() == 0 ? 0L : node.getAverageProcessingTimeMicros();
            if (node.isConnect()) {
                ++connected;
                connect = "Y";
                info = NettyUtils.getRemoteIpAddress((Channel)node.getChannel());
            } else {
                connect = "N";
                info = node.getIpAddr();
                avgTime = 0L;
            }
            String connectTm = sdf.format(new Date(node.getConnectTm()));
            String disconnectTm = sdf.format(new Date(node.getDisconnectTm()));
            String lastCommTm = sdf.format(new Date(node.getLastCommTm()));
            sb.append(String.format(" %5d%3s %10s %4s %7s %19s %19s %9d %6d %19s  %-15.15s  %6d %9d  %-19s %d/%d/%d", seqStart++, unknownNode, node.getKey(), check, connect, connectTm, disconnectTm, node.getConnectCount().get(), node.getDisconnectCount().get(), lastCommTm, info, node.getSigCount(), avgTime, String.format("%d/%d", node.getDroppedPacketCount(), node.getOverlappingPacketCount()), node.getPktQIdx(), node.getLogQIdx(), node.getDbmsQIdx())).append(this.sep);
        }
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        sb.append(String.format(" Total Nodes: %d EA, Registered: %d EA, Unknown: %d EA, Connected: %d EA", nodeCount, registered, unknown, connected)).append(this.sep);
        sb.append(String.format(" Unknown Nodes: %d EA, Unknown Node Buffers: %d EA, Unknown Ip Address: %d EA, Duplication Connect: %d EA", this.alarmManager.getUnknownNodeCount(), this.alarmManager.getUnknownNodeBufCount(), this.alarmManager.getUnknownIpAddrCount(), this.alarmManager.getDupConnectCount())).append(this.sep);
        sb.append(String.format(" Channel: %d EA, Session: %d EA", this.sessionManager.getChannelCount(), this.sessionManager.getCount())).append(this.sep);
        sb.append(String.format(" TRACE DUMP: %s", this.traceConfig.getCurrentDumpNodeIds().toString())).append(this.sep);
        sb.append(String.format(" TRACE TCP DUMP: %s", this.traceConfig.getCurrentTcpDumpIps().toString())).append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        return sb.toString();
    }

    @GetMapping(value={"/info/packet"}, produces={"application/json; charset=utf8"})
    public String infoPacket() {
        StringBuilder sb = this.getCommonHead();
        sb.append(" Packet Worker Queue Information.").append(this.sep);
        List processWorkerList = this.packetProcess.getWorkerList();
        List packetWorkers = processWorkerList.stream().filter(worker -> worker instanceof TsiCvimPacketWorker).map(worker -> (TsiCvimPacketWorker)worker).collect(Collectors.toList());
        int jobs = 0;
        for (TsiCvimPacketWorker tsiCvimPacketWorker : packetWorkers) {
            tsiCvimPacketWorker.setJobs(0);
        }
        for (Map.Entry entry : this.nodeManager.getTsiNodeVoMap().entrySet()) {
            TsiNodeVo node = (TsiNodeVo)entry.getValue();
            if (!node.isConnect()) continue;
            ++jobs;
            int pktIdx = node.getPktQIdx();
            if (pktIdx < 0 || pktIdx >= packetWorkers.size()) continue;
            ((TsiCvimPacketWorker)packetWorkers.get(pktIdx)).setJobs(((TsiCvimPacketWorker)packetWorkers.get(pktIdx)).getJobs() + 1);
        }
        sb.append(String.format(" Packet Worker: %d EA, QSize: %d EA.", processWorkerList.size(), this.packetProcess.getQSize())).append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        sb.append(" Worker-----   Jobs  Total  Used Remain  Process Average Time     Process Count").append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        int ii = 1;
        for (TsiCvimPacketWorker worker3 : packetWorkers) {
            sb.append(String.format(" Worker(%3d)  %5d  %5d %5d  %5d  %s  %d", ii++, worker3.getJobs(), worker3.getQSize(), worker3.getDATA_QUEUE().size(), worker3.getDATA_QUEUE().remainingCapacity(), TimeUtils.elapsedTimeStr2((long)worker3.getAvgTime()), worker3.getProcessedCount())).append(this.sep);
        }
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        sb.append(String.format(" Total Jobs: %d EA.", jobs)).append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        return sb.toString();
    }

    @GetMapping(value={"/info/logging"}, produces={"application/json; charset=utf8"})
    public String infoLogging() {
        StringBuilder sb = this.getCommonHead();
        sb.append(" Logging Worker Queue Information.").append(this.sep);
        if (!this.loggingProcess.isEnabled()) {
            sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
            sb.append(" Logging Worker is disabled (useLoggingThread=false).").append(this.sep);
            sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
            return sb.toString();
        }
        List loggingWorkerList = this.loggingProcess.getWorkerList();
        List loggingWorkers = loggingWorkerList.stream().filter(worker -> worker instanceof TsiCvimLoggingWorker).map(worker -> (TsiCvimLoggingWorker)worker).collect(Collectors.toList());
        int jobs = 0;
        for (AbstractTsiCvimWorker abstractTsiCvimWorker : loggingWorkerList) {
            abstractTsiCvimWorker.setJobs(0);
        }
        for (Map.Entry entry : this.nodeManager.getTsiNodeVoMap().entrySet()) {
            TsiNodeVo node = (TsiNodeVo)entry.getValue();
            if (!node.isConnect()) continue;
            ++jobs;
            int logIdx = node.getLogQIdx();
            if (logIdx < 0 || logIdx >= loggingWorkers.size()) continue;
            ((TsiCvimLoggingWorker)loggingWorkers.get(logIdx)).setJobs(((TsiCvimLoggingWorker)loggingWorkers.get(logIdx)).getJobs() + 1);
        }
        sb.append(String.format(" Logging Worker: %d EA, QSize: %d EA.", loggingWorkerList.size(), this.loggingProcess.getQSize())).append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        sb.append(" Worker-----   Jobs  Total  Used Remain  Process Average Time     Process Count").append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        int ii = 1;
        for (TsiCvimLoggingWorker worker3 : loggingWorkers) {
            sb.append(String.format(" Worker(%3d)  %5d  %5d %5d  %5d  %s  %d", ii++, worker3.getJobs(), worker3.getQSize(), worker3.getDATA_QUEUE().size(), worker3.getDATA_QUEUE().remainingCapacity(), TimeUtils.elapsedTimeStr2((long)worker3.getAvgTime()), worker3.getProcessedCount())).append(this.sep);
        }
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        sb.append(String.format(" Total Jobs: %d EA.", jobs)).append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        return sb.toString();
    }

    @GetMapping(value={"/info/dbms"}, produces={"application/json; charset=utf8"})
    public String infoDbms() {
        StringBuilder sb = this.getCommonHead();
        sb.append(" Dbms Worker Queue Information.").append(this.sep);
        List dbmsWorkerList = this.dbmsProcess.getWorkerList();
        List dbmsWorkers = dbmsWorkerList.stream().filter(worker -> worker instanceof TsiCvimDbmsWorker).map(worker -> (TsiCvimDbmsWorker)worker).collect(Collectors.toList());
        int jobs = 0;
        for (AbstractTsiCvimWorker abstractTsiCvimWorker : dbmsWorkerList) {
            abstractTsiCvimWorker.setJobs(0);
        }
        for (Map.Entry entry : this.nodeManager.getTsiNodeVoMap().entrySet()) {
            TsiNodeVo node = (TsiNodeVo)entry.getValue();
            if (!node.isConnect()) continue;
            ++jobs;
            int dbmsIdx = node.getDbmsQIdx();
            if (dbmsIdx < 0 || dbmsIdx >= dbmsWorkerList.size()) continue;
            ((AbstractTsiCvimWorker)dbmsWorkerList.get(dbmsIdx)).setJobs(((AbstractTsiCvimWorker)dbmsWorkerList.get(dbmsIdx)).getJobs() + 1);
        }
        sb.append(String.format(" Dbms Worker: %d EA, QSize: %d EA.", dbmsWorkerList.size(), this.dbmsProcess.getQSize())).append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        sb.append(" Worker-----   Jobs  Total  Used Remain  Process Average Time     Process Count").append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        int ii = 1;
        for (TsiCvimDbmsWorker worker3 : dbmsWorkers) {
            sb.append(String.format(" Worker(%3d)  %5d  %5d %5d  %5d  %s  %d", ii++, worker3.getJobs(), worker3.getQSize(), worker3.getDATA_QUEUE().size(), worker3.getDATA_QUEUE().remainingCapacity(), TimeUtils.elapsedTimeStr2((long)worker3.getAvgTime()), worker3.getProcessedCount())).append(this.sep);
        }
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        sb.append(String.format(" Total Jobs: %d EA.", jobs)).append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        return sb.toString();
    }

    @GetMapping(value={"/info/alarm"}, produces={"application/json; charset=utf8"})
    public String infoAlarm() {
        StringBuilder sb = this.getCommonHead();
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep).append(this.sep);
        sb.append("***Un Registered Node Information.").append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        sb.append("   SEQ Node ID     Remote-Address").append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        int ii = 1;
        for (Map.Entry obj : this.nodeManager.getTsiNodeVoMap().entrySet()) {
            TsiNodeVo node = (TsiNodeVo)obj.getValue();
            if (node.isRegistered()) continue;
            sb.append(String.format(" %5d %10s  %s", ii++, node.getKey(), node.getIpAddr())).append(this.sep);
        }
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep).append(this.sep);
        ii = 1;
        sb.append("**Node Id Zero Information.").append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        sb.append("   SEQ Remote-Address").append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        Set UNKNOWN_NODE_BUF_SET = this.alarmManager.getUNKNOWN_NODE_BUF_SET();
        for (Iterator ipAddr : UNKNOWN_NODE_BUF_SET) {
            sb.append(String.format(" %5d %s", ii++, ipAddr)).append(this.sep);
        }
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep).append(this.sep);
        ii = 1;
        sb.append("*Duplicated Connect Node Information.").append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        sb.append("   SEQ Information").append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        Set DUP_CONNECT_INFO_SET = this.alarmManager.getDUP_CONNECT_INFO_SET();
        for (String info : DUP_CONNECT_INFO_SET) {
            sb.append(String.format(" %5d %s", ii++, info)).append(this.sep);
        }
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep).append(this.sep);
        ii = 1;
        sb.append("*Signal Phase count zero Node Information.").append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        sb.append("   SEQ Information").append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        for (Map.Entry obj : this.nodeManager.getTsiNodeVoMap().entrySet()) {
            TsiNodeVo node = (TsiNodeVo)obj.getValue();
            if (!node.isConnect() || node.getSigCount() != 0) continue;
            sb.append(String.format(" %5d %d", ii++, node.getNodeId())).append(this.sep);
        }
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep).append(this.sep);
        ii = 1;
        sb.append("*CRC Error Node Information.").append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        sb.append("   SEQ Information").append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        Set CRC_ERROR_INFO_SET = this.alarmManager.getCRC_ERROR_INFO_SET();
        for (String info : CRC_ERROR_INFO_SET) {
            sb.append(String.format(" %5d %s", ii++, info)).append(this.sep);
        }
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep).append(this.sep);
        ii = 1;
        sb.append("*PACKET Error Node Information.").append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        sb.append("   SEQ Information").append(this.sep);
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        Set PACKET_ERROR_INFO_SET = this.alarmManager.getPACKET_ERROR_INFO_SET();
        for (String info : PACKET_ERROR_INFO_SET) {
            sb.append(String.format(" %5d %s", ii++, info)).append(this.sep);
        }
        sb.append("--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------").append(this.sep);
        return sb.toString();
    }

    public TsiCommServerRestController(ApplicationConfig config, TsiCvimServerConfig serverConfig, TraceConfig traceConfig, TsiNodeManager nodeManager, TsiSessionManager sessionManager, TsiAlarmManager alarmManager, TsiCvimPacketProcess packetProcess, TsiCvimLoggingProcess loggingProcess, TsiCvimDbmsProcess dbmsProcess) {
        this.config = config;
        this.serverConfig = serverConfig;
        this.traceConfig = traceConfig;
        this.nodeManager = nodeManager;
        this.sessionManager = sessionManager;
        this.alarmManager = alarmManager;
        this.packetProcess = packetProcess;
        this.loggingProcess = loggingProcess;
        this.dbmsProcess = dbmsProcess;
    }
}

