/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.kafka;

import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.config.TsiKafkaProducerConfig;
import com.tsi.comm.server.kafka.KafkaProducerFactory;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.repository.TsiAlarmManager;
import com.tsi.comm.server.repository.TsiTpmsManager;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.common.serialization.LongSerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureCallback;

@Service
public class KafkaProducerService {
    private static final Logger log = LoggerFactory.getLogger(KafkaProducerService.class);
    private final TsiCvimServerConfig config;
    private final TsiKafkaProducerConfig producerConfig;
    private final TsiAlarmManager alarmManager;
    private final TsiTpmsManager tpmsManager;
    private final TsiCvimDbmsProcess dbmsProcess;
    private KafkaTemplate<String, byte[]> cvimProducer;
    private KafkaTemplate<String, byte[]> nodeProducer;
    private KafkaTemplate<String, byte[]> testProducer;
    private KafkaTemplate<String, Long> pingProducer;

    public void start() {
        if (this.producerConfig.isMultiConnect()) {
            if (this.producerConfig.isEnableCvim()) {
                this.cvimProducer = KafkaProducerFactory.createByteArrayTemplate((String)this.producerConfig.getCvimServers(), (List)this.producerConfig.getProps());
                this.cvimProducer.setDefaultTopic("cvim-raw");
            }
            if (this.producerConfig.isEnableNode()) {
                this.nodeProducer = KafkaProducerFactory.createByteArrayTemplate((String)this.producerConfig.getNodeServers(), (List)this.producerConfig.getProps());
            }
            if (this.producerConfig.isEnableTest()) {
                this.testProducer = KafkaProducerFactory.createByteArrayTemplate((String)this.producerConfig.getTestServers(), (List)this.producerConfig.getProps());
                this.testProducer.setDefaultTopic("topic-for-ssd-test");
            }
        } else {
            KafkaTemplate producer = KafkaProducerFactory.createByteArrayTemplate((String)this.producerConfig.getBootstrapServers(), (List)this.producerConfig.getProps());
            if (this.producerConfig.isEnableCvim()) {
                this.cvimProducer = producer;
            }
            if (this.producerConfig.isEnableNode()) {
                this.nodeProducer = producer;
            }
            if (this.producerConfig.isEnableTest()) {
                this.testProducer = producer;
                this.testProducer.setDefaultTopic("topic-for-ssd-test");
            }
        }
        this.createPingProducer();
        log.info("[{}] ------------------", (Object)this.getClass().getSimpleName());
        log.info("[{}]   cvimProducer: {}", (Object)this.getClass().getSimpleName(), (Object)this.cvimProducer);
        log.info("[{}]   nodeProducer: {}", (Object)this.getClass().getSimpleName(), (Object)this.nodeProducer);
        log.info("[{}]   testProducer: {}", (Object)this.getClass().getSimpleName(), (Object)this.testProducer);
        log.info("[{}]   pingProducer: {}", (Object)this.getClass().getSimpleName(), (Object)this.pingProducer);
    }

    public void createPingProducer() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("bootstrap.servers", this.producerConfig.getBootstrapServers());
        props.put("acks", this.producerConfig.getConsumerAckConfig());
        props.put("retries", 0);
        props.put("linger.ms", 1);
        props.put("request.timeout.ms", 3000);
        props.put("delivery.timeout.ms", 4000);
        props.put("transaction.timeout.ms", 3000);
        props.put("key.serializer", StringSerializer.class);
        props.put("value.serializer", LongSerializer.class);
        this.pingProducer = KafkaProducerFactory.createProducerTemplate(props);
        this.pingProducer.setDefaultTopic("cvim_ping" + this.config.getServerId());
    }

    public void shutdown() {
        try {
            if (this.cvimProducer != null) {
                this.cvimProducer.destroy();
            }
            if (this.nodeProducer != null) {
                this.nodeProducer.destroy();
            }
            if (this.testProducer != null) {
                this.testProducer.destroy();
            }
            if (this.pingProducer != null) {
                this.pingProducer.destroy();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void sendPing() {
        if (this.pingProducer == null) {
            log.info("sendPing: pingProducer == null");
            return;
        }
        long sendNanoTime = System.nanoTime();
        this.tpmsManager.getKafkaTransVo().setSendNanoTime(sendNanoTime);
        this.tpmsManager.getKafkaTransVo().setSendTm(0L);
        this.tpmsManager.getKafkaTransVo().setRecvTm(0L);
        ListenableFuture future = this.pingProducer.sendDefault((Object)"key", (Object)sendNanoTime);
        future.addCallback((ListenableFutureCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void sendCvim(long key, byte[] data) {
        if (this.cvimProducer != null) {
            try {
                if (this.producerConfig.isMultiConnect()) {
                    this.cvimProducer.sendDefault((Object)Long.toString(key), (Object)data);
                } else {
                    this.cvimProducer.send("cvim-raw", (Object)Long.toString(key), (Object)data);
                }
            }
            catch (Exception e) {
                log.error("sendCvim: {}, {}: {}", new Object[]{"cvim-raw", key, e.getMessage()});
            }
        }
    }

    public void sendNode(String key, byte[] data) {
        if (this.nodeProducer != null) {
            try {
                this.nodeProducer.send(key, (Object)key, (Object)data);
            }
            catch (Exception e) {
                log.error("sendNode: {}, {}: {}", new Object[]{key, key, e.getMessage()});
            }
        }
    }

    public void sendTest(long key, byte[] data) {
        if (this.testProducer != null) {
            try {
                this.testProducer.sendDefault((Object)Long.toString(key), (Object)data);
            }
            catch (Exception e) {
                log.error("sendTest: {}, {}: {}", new Object[]{"topic-for-ssd-test", key, e.getMessage()});
            }
        }
    }

    public KafkaProducerService(TsiCvimServerConfig config, TsiKafkaProducerConfig producerConfig, TsiAlarmManager alarmManager, TsiTpmsManager tpmsManager, TsiCvimDbmsProcess dbmsProcess) {
        this.config = config;
        this.producerConfig = producerConfig;
        this.alarmManager = alarmManager;
        this.tpmsManager = tpmsManager;
        this.dbmsProcess = dbmsProcess;
    }

    static /* synthetic */ TsiTpmsManager access$000(KafkaProducerService x0) {
        return x0.tpmsManager;
    }

    static /* synthetic */ Logger access$100() {
        return log;
    }

    static /* synthetic */ TsiAlarmManager access$200(KafkaProducerService x0) {
        return x0.alarmManager;
    }

    static /* synthetic */ TsiKafkaProducerConfig access$300(KafkaProducerService x0) {
        return x0.producerConfig;
    }

    static /* synthetic */ TsiCvimDbmsProcess access$400(KafkaProducerService x0) {
        return x0.dbmsProcess;
    }
}

