/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.process.logging;

import com.tsi.comm.server.config.ApplicationConfig;
import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.process.AbstractTsiCvimProcess;
import com.tsi.comm.server.process.AbstractTsiCvimWorker;
import com.tsi.comm.server.process.logging.TsiCvimLoggingWorker;
import com.tsi.comm.server.process.packet.TsiCvimPacketWorker;
import com.tsi.comm.server.protocol.AbstractTsiPacket;
import com.tsi.comm.server.repository.TsiNodeManager;
import com.tsi.common.spring.SpringUtils;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class TsiCvimLoggingProcess
extends AbstractTsiCvimProcess {
    private static final Logger log = LoggerFactory.getLogger(TsiCvimLoggingProcess.class);
    private final ApplicationConfig config;
    private final TsiNodeManager nodeManager;
    private ExecutorService executor = null;
    private int qSize;

    public boolean isEnabled() {
        return this.config.isUseLoggingThread();
    }

    public List<AbstractTsiCvimWorker> getWorkerList() {
        if (!this.isEnabled()) {
            return Collections.emptyList();
        }
        return super.getWorkerList();
    }

    public int getQSize() {
        if (!this.isEnabled()) {
            return 0;
        }
        return this.qSize;
    }

    public void start() {
        if (!this.config.isUseLoggingThread()) {
            return;
        }
        ThreadGroup workerGroup = new ThreadGroup("loggingProcess");
        TsiCvimServerConfig tsiCvimServerConfig = (TsiCvimServerConfig)SpringUtils.getBean(TsiCvimServerConfig.class);
        this.workers = tsiCvimServerConfig.getLoggingWorkers();
        this.qSize = Math.max(10, this.nodeManager.size());
        if (this.workers == 1) {
            this.qSize *= 2;
        }
        this.executor = Executors.newFixedThreadPool(this.workers, (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
        for (int ii = 0; ii < this.workers; ++ii) {
            TsiCvimLoggingWorker loggingWorker = new TsiCvimLoggingWorker(ii, this.qSize);
            this.workerList.add(loggingWorker);
            this.executor.submit((Runnable)loggingWorker);
        }
    }

    public boolean add(Object object, int idx) {
        if (!this.config.isUseLoggingThread()) {
            return false;
        }
        boolean offer = false;
        AbstractTsiPacket packet = (AbstractTsiPacket)object;
        try {
            if (idx >= 0 && idx < this.workers) {
                offer = ((AbstractTsiCvimWorker)this.workerList.get(idx)).add((Object)packet);
            } else {
                log.error("LoggingProcess: Invalid logging queue index: {}", (Object)idx);
            }
        }
        catch (Exception e) {
            MDC.put((String)"id", (String)Long.toString(packet.getNodeId()));
            log.error("LoggingProcess: QUEUE_DATA.add: Exception: {}, {}", (Object)packet.getNodeId(), (Object)e.getMessage());
            MDC.clear();
        }
        return offer;
    }

    public void stop() {
        log.info("LoggingProcess Stopping...");
        if (!this.config.isUseLoggingThread()) {
            return;
        }
        for (AbstractTsiCvimWorker worker : this.workerList) {
            try {
                ((TsiCvimLoggingWorker)worker).getDATA_QUEUE().put(TsiCvimLoggingWorker.SHUTDOWN_PACKET);
            }
            catch (InterruptedException e) {
                log.warn("LoggingProcess: Interrupted while sending shutdown signal to worker {}.", (Object)worker.getIdx());
                Thread.currentThread().interrupt();
            }
        }
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(3L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                int remainingTasks = 0;
                for (AbstractTsiCvimWorker worker : this.workerList) {
                    remainingTasks += ((TsiCvimPacketWorker)worker).getDATA_QUEUE().size();
                }
                if (remainingTasks > 0) {
                    log.warn("LoggingProcess: queue remain {}, forced shutdown.", (Object)remainingTasks);
                }
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    log.error("LoggingProcess: Executor did not terminate even after forced shutdown.");
                }
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        log.info("LoggingProcess Stopped...");
    }

    public void report() {
        if (!this.config.isUseLoggingThread()) {
            return;
        }
        for (AbstractTsiCvimWorker worker : this.workerList) {
            worker.report();
        }
    }

    public ApplicationConfig getConfig() {
        return this.config;
    }

    public TsiNodeManager getNodeManager() {
        return this.nodeManager;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public TsiCvimLoggingProcess(ApplicationConfig config, TsiNodeManager nodeManager) {
        this.config = config;
        this.nodeManager = nodeManager;
    }

    static /* synthetic */ int access$000(TsiCvimLoggingProcess x0) {
        return x0.workers;
    }
}

