/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.process.packet;

import com.tsi.comm.server.config.ApplicationConfig;
import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.kafka.KafkaProducerService;
import com.tsi.comm.server.process.AbstractTsiCvimProcess;
import com.tsi.comm.server.process.AbstractTsiCvimWorker;
import com.tsi.comm.server.process.packet.TsiCvimPacketWorker;
import com.tsi.comm.server.protocol.AbstractTsiPacket;
import com.tsi.comm.server.protocol.TsiCpuPacket;
import com.tsi.comm.server.repository.TsiNodeManager;
import com.tsi.comm.server.vo.TsiNodeVo;
import com.tsi.common.spring.SpringUtils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Service;

@Service
public class TsiCvimPacketProcess
extends AbstractTsiCvimProcess {
    private static final Logger log = LoggerFactory.getLogger(TsiCvimPacketProcess.class);
    private final ApplicationConfig config;
    private final KafkaProducerService kafkaProducerService;
    private final TsiNodeManager nodeManager;
    private ExecutorService executor = null;
    private int qSize;

    public void start() {
        ThreadGroup workerGroup = new ThreadGroup("packetProcess");
        TsiCvimServerConfig tsiCvimServerConfig = (TsiCvimServerConfig)SpringUtils.getBean(TsiCvimServerConfig.class);
        this.workers = tsiCvimServerConfig.getPacketWorkers();
        this.qSize = Math.max(10, this.nodeManager.size());
        if (this.workers == 1) {
            this.qSize *= 3;
        }
        this.executor = Executors.newFixedThreadPool(this.workers, (ThreadFactory)new /* Unavailable Anonymous Inner Class!! */);
        for (int ii = 0; ii < this.workers; ++ii) {
            TsiCvimPacketWorker packetWorker = new TsiCvimPacketWorker(ii, this.qSize, this.kafkaProducerService, this.config.isUseLoggingThread());
            this.workerList.add(packetWorker);
            this.executor.submit((Runnable)packetWorker);
        }
    }

    private void warmUpWorkers() {
        int warmUpRounds = 10000;
        log.info("Starting JIT compiler warm-up for {} packet workers with {} rounds each...", (Object)this.workers, (Object)warmUpRounds);
        TsiNodeVo dummyNodeVo = new TsiNodeVo(1L, "127.0.0.1", false, false, false);
        long startTime = System.currentTimeMillis();
        int i = 0;
        while (i < this.workers) {
            int workerIndex = i++;
            new Thread(() -> {
                for (int j = 0; j < warmUpRounds; ++j) {
                    TsiCpuPacket warmUpPacket = this.createWarmUpPacket(dummyNodeVo);
                    ((AbstractTsiCvimWorker)this.workerList.get(workerIndex)).add((Object)warmUpPacket);
                }
            }).start();
        }
        log.info("Warm-up tasks submitted. Main process continues...");
    }

    private TsiCpuPacket createWarmUpPacket(TsiNodeVo dummyNodeVo) {
        long nodeId = dummyNodeVo.getNodeId();
        long msec = System.currentTimeMillis();
        long nsec = System.nanoTime();
        int packetSize = 100;
        byte[] dummyBytes = new byte[packetSize];
        TsiCpuPacket packet = new TsiCpuPacket(nodeId, msec, nsec, 0L, 0);
        packet.setBuf(dummyBytes);
        packet.setObj((Object)dummyNodeVo);
        return packet;
    }

    public boolean add(Object object, int idx) {
        boolean offer = false;
        AbstractTsiPacket packet = (AbstractTsiPacket)object;
        try {
            if (idx >= 0 && idx < this.workers) {
                offer = ((AbstractTsiCvimWorker)this.workerList.get(idx)).add((Object)packet);
            } else {
                log.error("PacketProcess: Invalid packet queue index: {}", (Object)idx);
            }
        }
        catch (Exception e) {
            MDC.put((String)"id", (String)Long.toString(packet.getNodeId()));
            log.error("PacketProcess: QUEUE_DATA.add: Exception: {}, {}", (Object)packet.getNodeId(), (Object)e.getMessage());
            MDC.clear();
        }
        return offer;
    }

    public void stop() {
        log.info("PacketProcess Stopping...");
        for (AbstractTsiCvimWorker worker : this.workerList) {
            try {
                ((TsiCvimPacketWorker)worker).getDATA_QUEUE().put(TsiCvimPacketWorker.SHUTDOWN_PACKET);
            }
            catch (InterruptedException e) {
                log.warn("PacketProcess: Interrupted while sending shutdown signal to worker {}.", (Object)worker.getIdx());
                Thread.currentThread().interrupt();
            }
        }
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(3L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                int remainingTasks = 0;
                for (AbstractTsiCvimWorker worker : this.workerList) {
                    remainingTasks += ((TsiCvimPacketWorker)worker).getDATA_QUEUE().size();
                }
                if (remainingTasks > 0) {
                    log.warn("PacketProcess: queue remain {}, forced shutdown.", (Object)remainingTasks);
                }
                if (!this.executor.awaitTermination(1L, TimeUnit.SECONDS)) {
                    log.error("PacketProcess: Executor did not terminate even after forced shutdown.");
                }
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
        log.info("PacketProcess Stopped...");
    }

    public void report() {
        for (AbstractTsiCvimWorker worker : this.workerList) {
            worker.report();
        }
    }

    public ApplicationConfig getConfig() {
        return this.config;
    }

    public KafkaProducerService getKafkaProducerService() {
        return this.kafkaProducerService;
    }

    public TsiNodeManager getNodeManager() {
        return this.nodeManager;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public int getQSize() {
        return this.qSize;
    }

    public TsiCvimPacketProcess(ApplicationConfig config, KafkaProducerService kafkaProducerService, TsiNodeManager nodeManager) {
        this.config = config;
        this.kafkaProducerService = kafkaProducerService;
        this.nodeManager = nodeManager;
    }

    static /* synthetic */ int access$000(TsiCvimPacketProcess x0) {
        return x0.workers;
    }
}

