/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.protocol;

import com.tsi.comm.server.protocol.TsiCpuAddPacket;
import com.tsi.comm.server.protocol.TsiCpuPacket;
import com.tsi.comm.server.protocol.enums.eOpCode;
import com.tsi.comm.server.vo.TsiNodeAddDetailVo;
import com.tsi.comm.server.vo.TsiNodeAddVo;
import com.tsi.comm.server.vo.TsiNodeVo;
import com.tsi.common.utils.ByteUtils;
import com.tsi.common.utils.TimeUtils;
import java.util.ArrayList;

public class TsiCpuDisconnected
extends TsiCpuPacket {
    public TsiCpuDisconnected(long nodeId, long remoteIpAddress, int remotePort) {
        super(nodeId, TimeUtils.currentTimeSeconds(), System.nanoTime(), remoteIpAddress, remotePort);
        this.setOpCode(eOpCode.TSI_CPU_DISCONNECTED.getValue());
    }

    protected void makeAddNodeCvimPaket(TsiCpuPacket cpuPacket) {
        cpuPacket.cvimData = new byte[27];
        System.arraycopy(this.timespec.bytes(), 0, cpuPacket.cvimData, 0, 16);
        ByteUtils.setUnsignedInt((byte[])cpuPacket.cvimData, (int)16, (long)this.getRemoteIp());
        ByteUtils.setUnsignedShort((byte[])cpuPacket.cvimData, (int)20, (int)this.getRemotePort());
        cpuPacket.cvimData[22] = 0;
        ByteUtils.setUnsignedInt((byte[])cpuPacket.cvimData, (int)23, (long)cpuPacket.nodeId);
    }

    public boolean parsing(TsiNodeVo nodeVo) {
        if (nodeVo == null) {
            return false;
        }
        this.makeCvimPacket();
        TsiNodeAddVo tsiNodeAddVo = TsiCpuPacket.nodeAddManager.get(this.nodeId);
        if (tsiNodeAddVo == null) {
            return true;
        }
        this.addNodes = new ArrayList();
        for (Integer key : tsiNodeAddVo.getAddNodeMap().keySet()) {
            TsiNodeAddDetailVo detailVo = (TsiNodeAddDetailVo)tsiNodeAddVo.getAddNodeMap().get(key);
            TsiCpuAddPacket addPacket = new TsiCpuAddPacket(detailVo.getNodeId(), this.timespec, this.remoteIp, this.remotePort);
            this.makeAddNodeCvimPaket((TsiCpuPacket)addPacket);
            this.addNodes.add(addPacket);
        }
        return true;
    }
}

