/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.repository;

import com.tsi.comm.server.vo.TsiAlarmConfigVo;
import com.tsi.comm.server.xnet.NettyUtils;
import com.tsi.common.utils.HexString;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
public class TsiAlarmManager {
    private static final Logger log = LoggerFactory.getLogger(TsiAlarmManager.class);
    private final ConcurrentHashMap<String, TsiAlarmConfigVo> tsiAlarmConfigMap = new ConcurrentHashMap();
    private final Set<String> UNKNOWN_NODE_SET = ConcurrentHashMap.newKeySet();
    private final Set<String> UNKNOWN_NODE_BUF_SET = ConcurrentHashMap.newKeySet();
    private final Set<String> UNKNOWN_IPADDR_SET = ConcurrentHashMap.newKeySet();
    private final Set<String> DUP_CONNECT_INFO_SET = ConcurrentHashMap.newKeySet();
    private final Set<String> CRC_ERROR_INFO_SET = ConcurrentHashMap.newKeySet();
    private final Set<String> PACKET_ERROR_INFO_SET = ConcurrentHashMap.newKeySet();

    public TsiAlarmConfigVo get(String code) {
        return (TsiAlarmConfigVo)this.tsiAlarmConfigMap.get(code);
    }

    public void put(String code, TsiAlarmConfigVo vo) {
        this.tsiAlarmConfigMap.put(code, vo);
    }

    public int size() {
        return this.tsiAlarmConfigMap.size();
    }

    public boolean checkAlarm(String code) {
        TsiAlarmConfigVo vo = this.get(code);
        return vo != null && vo.isUseYn();
    }

    public int getUnknownNodeCount() {
        return this.UNKNOWN_NODE_SET.size();
    }

    public int getUnknownNodeBufCount() {
        return this.UNKNOWN_NODE_BUF_SET.size();
    }

    public int getUnknownIpAddrCount() {
        return this.UNKNOWN_IPADDR_SET.size();
    }

    public int getDupConnectCount() {
        return this.DUP_CONNECT_INFO_SET.size();
    }

    public void loggingUnknownNode(long nodeId, Channel channel) {
        String remoteIpAddress = NettyUtils.getRemoteIpAddress((Channel)channel);
        if (this.UNKNOWN_NODE_SET.contains(remoteIpAddress)) {
            return;
        }
        this.UNKNOWN_NODE_SET.add(remoteIpAddress);
        String fileName = "unknown_node";
        MDC.put((String)"filename", (String)"unknown_node");
        if (nodeId > 0L) {
            log.info("Node: {}, {}, unknown node id registered.", (Object)nodeId, (Object)remoteIpAddress);
        } else {
            log.info("Node: {}, {}", (Object)nodeId, (Object)remoteIpAddress);
        }
        MDC.clear();
    }

    public void loggingUnknownNodePacket(long nodeId, Channel channel, byte[] buf) {
        String remoteIpAddress = NettyUtils.getRemoteIpAddress((Channel)channel);
        if (this.UNKNOWN_NODE_BUF_SET.contains(remoteIpAddress)) {
            return;
        }
        this.UNKNOWN_NODE_BUF_SET.add(remoteIpAddress);
        String fileName = "unknown_node_packet";
        MDC.put((String)"filename", (String)"unknown_node_packet");
        log.info("Node: {}, {}, [{}]", new Object[]{nodeId, remoteIpAddress, HexString.fromBytes((byte[])buf)});
        MDC.clear();
    }

    public void reportUnknownIp(String ipAddr) {
        if (this.UNKNOWN_IPADDR_SET.contains(ipAddr)) {
            return;
        }
        this.UNKNOWN_IPADDR_SET.add(ipAddr);
        String fileName = "unknown_ip";
        MDC.put((String)"filename", (String)"unknown_ip");
        log.info("Unknown IP Address: {}", (Object)ipAddr);
        MDC.clear();
    }

    public void alarmDupConnect(Long nodeId, String ipAddr, String remoteIpAddress) {
        String dupConnectInfo = nodeId + ":" + ipAddr + ":" + remoteIpAddress;
        if (this.DUP_CONNECT_INFO_SET.contains(dupConnectInfo)) {
            return;
        }
        this.DUP_CONNECT_INFO_SET.add(dupConnectInfo);
        String fileName = "dup_connect";
        MDC.put((String)"filename", (String)"dup_connect");
        log.info("Duplication Connect: {}", (Object)dupConnectInfo);
        MDC.clear();
    }

    public void reportCrcError(Long nodeId, byte[] buf, int receivedCrc, int calculatedCrc) {
        if (buf == null) {
            return;
        }
        String errorInfo = nodeId + "";
        if (this.CRC_ERROR_INFO_SET.contains(errorInfo)) {
            return;
        }
        this.CRC_ERROR_INFO_SET.add(errorInfo);
        String fileName = "crc_error";
        MDC.put((String)"filename", (String)"crc_error");
        try {
            log.info("CRC Error: NodeId: {}, {} Bytes, crc(recv/calc): {}/{}", new Object[]{nodeId, buf.length, receivedCrc, calculatedCrc});
            log.error("{}", (Object)ByteBufUtil.hexDump((byte[])buf));
        }
        catch (Exception exception) {
            // empty catch block
        }
        MDC.clear();
    }

    public void reportPacketError(Long nodeId, byte[] buf, String errType, int value1, int value2) {
        if (buf == null) {
            return;
        }
        String errorInfo = nodeId + ":" + errType;
        if (this.PACKET_ERROR_INFO_SET.contains(errorInfo)) {
            return;
        }
        this.PACKET_ERROR_INFO_SET.add(errorInfo);
        String fileName = "crc_error";
        MDC.put((String)"filename", (String)"crc_error");
        try {
            log.info("Packet Error: NodeId: {}, {} Bytes, {}: {}/{}", new Object[]{nodeId, buf.length, errType, value1, value2});
            log.error("{}", (Object)ByteBufUtil.hexDump((byte[])buf));
        }
        catch (Exception exception) {
            // empty catch block
        }
        MDC.clear();
    }

    public ConcurrentHashMap<String, TsiAlarmConfigVo> getTsiAlarmConfigMap() {
        return this.tsiAlarmConfigMap;
    }

    public Set<String> getUNKNOWN_NODE_SET() {
        return this.UNKNOWN_NODE_SET;
    }

    public Set<String> getUNKNOWN_NODE_BUF_SET() {
        return this.UNKNOWN_NODE_BUF_SET;
    }

    public Set<String> getUNKNOWN_IPADDR_SET() {
        return this.UNKNOWN_IPADDR_SET;
    }

    public Set<String> getDUP_CONNECT_INFO_SET() {
        return this.DUP_CONNECT_INFO_SET;
    }

    public Set<String> getCRC_ERROR_INFO_SET() {
        return this.CRC_ERROR_INFO_SET;
    }

    public Set<String> getPACKET_ERROR_INFO_SET() {
        return this.PACKET_ERROR_INFO_SET;
    }
}

