/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.repository;

import com.tsi.comm.server.vo.TsiNodeVo;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TsiNodeManager {
    private static final Logger log = LoggerFactory.getLogger(TsiNodeManager.class);
    private final ConcurrentHashMap<Long, TsiNodeVo> tsiNodeVoMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, TsiNodeVo> ipAddrMap = new ConcurrentHashMap();

    public TsiNodeVo getOrCompute(long nodeId, Function<Long, TsiNodeVo> mappingFunction) {
        return this.tsiNodeVoMap.computeIfAbsent(nodeId, mappingFunction);
    }

    public TsiNodeVo get(long nodeId) {
        return (TsiNodeVo)this.tsiNodeVoMap.get(nodeId);
    }

    public void put(long nodeId, TsiNodeVo vo) {
        this.tsiNodeVoMap.put(nodeId, vo);
    }

    public int size() {
        return this.tsiNodeVoMap.size();
    }

    public Collection<TsiNodeVo> getAllNodes() {
        return this.tsiNodeVoMap.values();
    }

    public TsiNodeVo getIpAddr(String ipAddr) {
        if (ipAddr == null || ipAddr.isEmpty()) {
            return null;
        }
        return (TsiNodeVo)this.ipAddrMap.get(ipAddr);
    }

    public void putIpAddr(String ipAddr, TsiNodeVo vo) {
        if (ipAddr == null || ipAddr.isEmpty()) {
            return;
        }
        this.ipAddrMap.put(ipAddr, vo);
    }

    public void removeIpAddr(String ipAddr) {
        if (ipAddr == null || ipAddr.isEmpty()) {
            return;
        }
        this.ipAddrMap.remove(ipAddr);
    }

    public int sizeIpAddr() {
        return this.ipAddrMap.size();
    }

    public boolean containsKey(long key) {
        return this.tsiNodeVoMap.containsKey(key);
    }

    public void beforeLoading() {
        for (Map.Entry obj : this.tsiNodeVoMap.entrySet()) {
            ((TsiNodeVo)obj.getValue()).setCheckInstalled(false);
        }
    }

    public void afterLoading() {
        for (Map.Entry obj : this.tsiNodeVoMap.entrySet()) {
            if (!((TsiNodeVo)obj.getValue()).isRegistered()) continue;
            ((TsiNodeVo)obj.getValue()).setInstalled(((TsiNodeVo)obj.getValue()).isCheckInstalled());
        }
    }

    public ConcurrentHashMap<Long, TsiNodeVo> getTsiNodeVoMap() {
        return this.tsiNodeVoMap;
    }

    public ConcurrentHashMap<String, TsiNodeVo> getIpAddrMap() {
        return this.ipAddrMap;
    }
}

