/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.tcp.handler;

import com.tsi.comm.server.tcp.service.ConnectionLifecycleService;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.timeout.IdleStateEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class CvimServerInboundMessageHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger log = LoggerFactory.getLogger(CvimServerInboundMessageHandler.class);
    private final ConnectionLifecycleService connectionService;

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.connectionService.handleChannelActive(ctx);
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.connectionService.handleChannelInactive(ctx);
        ctx.fireChannelInactive();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object e) throws Exception {
        if (e instanceof IdleStateEvent) {
            this.connectionService.handleIdleStateEvent(ctx, (IdleStateEvent)e);
        }
        ctx.fireUserEventTriggered(e);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.connectionService.handleExceptionCaught(ctx, cause);
        ctx.fireExceptionCaught(cause);
        ctx.channel().close();
    }

    public CvimServerInboundMessageHandler(ConnectionLifecycleService connectionService) {
        this.connectionService = connectionService;
    }
}

