/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.tcp.handler;

import com.tsi.comm.server.xnet.NettyUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import java.net.SocketAddress;
import org.slf4j.MDC;

public class MdcLoggingHandler
extends LoggingHandler {
    public MdcLoggingHandler(LogLevel level) {
        super(level);
    }

    private void setMdc(ChannelHandlerContext ctx) {
        String remoteIpAddress = NettyUtils.getRemoteIpAddress((Channel)ctx.channel());
        MDC.put((String)"id", (String)remoteIpAddress);
    }

    private void clearMdc() {
        MDC.remove((String)"id");
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.setMdc(ctx);
        try {
            super.channelRegistered(ctx);
        }
        finally {
            this.clearMdc();
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.setMdc(ctx);
        try {
            super.channelUnregistered(ctx);
        }
        finally {
            this.clearMdc();
        }
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.setMdc(ctx);
        try {
            super.channelActive(ctx);
        }
        finally {
            this.clearMdc();
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.setMdc(ctx);
        try {
            super.channelInactive(ctx);
        }
        finally {
            this.clearMdc();
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.setMdc(ctx);
        try {
            super.channelRead(ctx, msg);
        }
        finally {
            this.clearMdc();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.setMdc(ctx);
        try {
            super.channelReadComplete(ctx);
        }
        finally {
            this.clearMdc();
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        this.setMdc(ctx);
        try {
            super.userEventTriggered(ctx, evt);
        }
        finally {
            this.clearMdc();
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        this.setMdc(ctx);
        try {
            super.channelWritabilityChanged(ctx);
        }
        finally {
            this.clearMdc();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.setMdc(ctx);
        try {
            super.exceptionCaught(ctx, cause);
        }
        finally {
            this.clearMdc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.setMdc(ctx);
        try {
            super.bind(ctx, localAddress, promise);
        }
        finally {
            this.clearMdc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
        this.setMdc(ctx);
        try {
            super.connect(ctx, remoteAddress, localAddress, promise);
        }
        finally {
            this.clearMdc();
        }
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.setMdc(ctx);
        try {
            super.disconnect(ctx, promise);
        }
        finally {
            this.clearMdc();
        }
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.setMdc(ctx);
        try {
            super.close(ctx, promise);
        }
        finally {
            this.clearMdc();
        }
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        this.setMdc(ctx);
        try {
            super.deregister(ctx, promise);
        }
        finally {
            this.clearMdc();
        }
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        this.setMdc(ctx);
        try {
            super.read(ctx);
        }
        finally {
            this.clearMdc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        this.setMdc(ctx);
        try {
            super.write(ctx, msg, promise);
        }
        finally {
            this.clearMdc();
        }
    }

    public void flush(ChannelHandlerContext ctx) throws Exception {
        this.setMdc(ctx);
        try {
            super.flush(ctx);
        }
        finally {
            this.clearMdc();
        }
    }
}

