/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.xnet;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class NetUtils {
    private NetUtils() {
    }

    public static String formatInetAddr(InetSocketAddress addr) {
        InetAddress ia = addr.getAddress();
        if (ia == null) {
            return String.format("%s:%s", addr.getHostString(), addr.getPort());
        }
        if (ia instanceof Inet6Address) {
            return String.format("[%s]:%s", ia.getHostAddress(), addr.getPort());
        }
        return String.format("%s:%s", ia.getHostAddress(), addr.getPort());
    }

    public static long ipToLong(String ipAddress) {
        String[] ipAddressInArray = ipAddress.split("\\.");
        long result = 0L;
        for (int i = 0; i < ipAddressInArray.length; ++i) {
            int power = 3 - i;
            int ip = Integer.parseInt(ipAddressInArray[i]);
            result = (long)((double)result + (double)ip * Math.pow(256.0, power));
        }
        return result;
    }

    public static long ipToLong2(String ipAddress) {
        long result = 0L;
        String[] ipAddressInArray = ipAddress.split("\\.");
        for (int i = 3; i >= 0; --i) {
            long ip = Long.parseLong(ipAddressInArray[3 - i]);
            result |= ip << i * 8;
        }
        return result;
    }

    public static String longToIp(long i) {
        return (i >> 24 & 0xFFL) + "." + (i >> 16 & 0xFFL) + "." + (i >> 8 & 0xFFL) + "." + (i & 0xFFL);
    }

    public static String longToIp2(long ip) {
        StringBuilder sb = new StringBuilder(15);
        for (int i = 0; i < 4; ++i) {
            sb.insert(0, Long.toString(ip & 0xFFL));
            if (i < 3) {
                sb.insert(0, '.');
            }
            ip >>= 8;
        }
        return sb.toString();
    }

    public static String getLocalIp4Addr() {
        String ipv4addr = null;
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address) || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                    ipv4addr = ip.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return ipv4addr;
    }

    public static String getHostAddress() {
        String hostAddress;
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hostAddress = localhost.getHostAddress();
        }
        catch (UnknownHostException e) {
            hostAddress = "127.0.0.1";
        }
        return hostAddress;
    }

    public static String getHostName() {
        String hostName;
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            hostName = localhost.getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        return hostName;
    }
}

