/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.xnet;

import com.tsi.comm.server.xnet.NettyServerConfig;
import com.tsi.comm.server.xnet.NettyUtils;
import com.tsi.comm.server.xnet.ServerBootstrapFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NettyTcpServer {
    private static final Logger log = LoggerFactory.getLogger(NettyTcpServer.class);
    private final NettyServerConfig config;
    private EventLoopGroup acceptGroups = null;
    private EventLoopGroup workerGroups = null;
    private ServerBootstrap serverBootstrap = null;
    private ChannelFuture channelFuture = null;
    private ChannelInitializer<Channel> channelInitializer;

    public NettyTcpServer(NettyServerConfig config) {
        this.config = config;
    }

    public void run() {
        try {
            if (NettyUtils.isEpollAvailable()) {
                log.info("Server is running in Linux EPOLL mode.");
            } else {
                log.info("Server is running in Windows NIO mode.");
            }
            this.serverBootstrap = ServerBootstrapFactory.createBootstrap((NettyServerConfig)this.config, (ChannelInitializer)this.channelInitializer);
        }
        catch (Exception e) {
            log.error("NettyTcpServer createBootstrap exception: {}", (Object)e.getMessage());
        }
        log.info("  bindAddress: {}", (Object)this.config.getBindingAddr());
        log.info("     bindPort: {}", (Object)this.config.getBindingPort());
        log.info("      backlog: {}", (Object)this.config.getBacklog());
        log.info("acceptThreads: {}", (Object)this.config.getAcceptThreads());
        log.info("workerThreads: {}", (Object)this.config.getWorkerThreads());
        try {
            this.channelFuture = this.config.getBindingAddr().equals("0.0.0.0") ? this.serverBootstrap.bind(this.config.getBindingPort()) : this.serverBootstrap.bind(this.config.getBindingAddr(), this.config.getBindingPort());
        }
        catch (Exception e) {
            log.error("NettyTcpServer bind exception: {}", (Object)e.getMessage());
            this.acceptGroups.shutdownGracefully();
            this.workerGroups.shutdownGracefully();
        }
    }

    public void stop() {
        try {
            this.acceptGroups.shutdownGracefully().sync();
            this.workerGroups.shutdownGracefully().sync();
            this.channelFuture.channel().closeFuture().sync();
        }
        catch (InterruptedException e) {
            log.error("NettyTcpServer stop interrupt: {}", (Object)e.getMessage());
        }
    }

    public NettyServerConfig getConfig() {
        return this.config;
    }

    public EventLoopGroup getAcceptGroups() {
        return this.acceptGroups;
    }

    public EventLoopGroup getWorkerGroups() {
        return this.workerGroups;
    }

    public ServerBootstrap getServerBootstrap() {
        return this.serverBootstrap;
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }

    public ChannelInitializer<Channel> getChannelInitializer() {
        return this.channelInitializer;
    }

    public void setAcceptGroups(EventLoopGroup acceptGroups) {
        this.acceptGroups = acceptGroups;
    }

    public void setWorkerGroups(EventLoopGroup workerGroups) {
        this.workerGroups = workerGroups;
    }

    public void setServerBootstrap(ServerBootstrap serverBootstrap) {
        this.serverBootstrap = serverBootstrap;
    }

    public void setChannelFuture(ChannelFuture channelFuture) {
        this.channelFuture = channelFuture;
    }

    public void setChannelInitializer(ChannelInitializer<Channel> channelInitializer) {
        this.channelInitializer = channelInitializer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NettyTcpServer)) {
            return false;
        }
        NettyTcpServer other = (NettyTcpServer)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        NettyServerConfig this$config = this.getConfig();
        NettyServerConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !this$config.equals(other$config)) {
            return false;
        }
        EventLoopGroup this$acceptGroups = this.getAcceptGroups();
        EventLoopGroup other$acceptGroups = other.getAcceptGroups();
        if (this$acceptGroups == null ? other$acceptGroups != null : !this$acceptGroups.equals(other$acceptGroups)) {
            return false;
        }
        EventLoopGroup this$workerGroups = this.getWorkerGroups();
        EventLoopGroup other$workerGroups = other.getWorkerGroups();
        if (this$workerGroups == null ? other$workerGroups != null : !this$workerGroups.equals(other$workerGroups)) {
            return false;
        }
        ServerBootstrap this$serverBootstrap = this.getServerBootstrap();
        ServerBootstrap other$serverBootstrap = other.getServerBootstrap();
        if (this$serverBootstrap == null ? other$serverBootstrap != null : !this$serverBootstrap.equals(other$serverBootstrap)) {
            return false;
        }
        ChannelFuture this$channelFuture = this.getChannelFuture();
        ChannelFuture other$channelFuture = other.getChannelFuture();
        if (this$channelFuture == null ? other$channelFuture != null : !this$channelFuture.equals(other$channelFuture)) {
            return false;
        }
        ChannelInitializer this$channelInitializer = this.getChannelInitializer();
        ChannelInitializer other$channelInitializer = other.getChannelInitializer();
        return !(this$channelInitializer == null ? other$channelInitializer != null : !this$channelInitializer.equals(other$channelInitializer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NettyTcpServer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        NettyServerConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : $config.hashCode());
        EventLoopGroup $acceptGroups = this.getAcceptGroups();
        result = result * 59 + ($acceptGroups == null ? 43 : $acceptGroups.hashCode());
        EventLoopGroup $workerGroups = this.getWorkerGroups();
        result = result * 59 + ($workerGroups == null ? 43 : $workerGroups.hashCode());
        ServerBootstrap $serverBootstrap = this.getServerBootstrap();
        result = result * 59 + ($serverBootstrap == null ? 43 : $serverBootstrap.hashCode());
        ChannelFuture $channelFuture = this.getChannelFuture();
        result = result * 59 + ($channelFuture == null ? 43 : $channelFuture.hashCode());
        ChannelInitializer $channelInitializer = this.getChannelInitializer();
        result = result * 59 + ($channelInitializer == null ? 43 : $channelInitializer.hashCode());
        return result;
    }

    public String toString() {
        return "NettyTcpServer(config=" + this.getConfig() + ", acceptGroups=" + this.getAcceptGroups() + ", workerGroups=" + this.getWorkerGroups() + ", serverBootstrap=" + this.getServerBootstrap() + ", channelFuture=" + this.getChannelFuture() + ", channelInitializer=" + this.getChannelInitializer() + ")";
    }
}

