/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.xnet;

import com.tsi.comm.server.xnet.NettyServerConfig;
import com.tsi.comm.server.xnet.NettyUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerBootstrapFactory {
    private static final Logger log = LoggerFactory.getLogger(ServerBootstrapFactory.class);

    public static ServerBootstrap createBootstrap(NettyServerConfig config, ChannelInitializer<Channel> channelInitializer) throws Exception {
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        log.info("[createBootstrap] ==================================");
        log.info("[createBootstrap] -         acceptThreads: {}", (Object)config.getAcceptThreads());
        log.info("[createBootstrap] -         workerThreads: {}", (Object)config.getWorkerThreads());
        log.info("[createBootstrap] -               backlog: {}", (Object)config.getBacklog());
        log.info("[createBootstrap] -                rcvBuf: {}", (Object)config.getRcvBuf());
        log.info("[createBootstrap] - connectTimeoutSeconds: {}", (Object)config.getConnectTimeoutSeconds());
        log.info("[createBootstrap] ==================================");
        EventLoopGroup acceptGroups = NettyUtils.newEventLoopGroup((int)config.getAcceptThreads(), (String)"Accept");
        EventLoopGroup workerGroups = NettyUtils.newEventLoopGroup((int)config.getWorkerThreads(), (String)"Worker");
        serverBootstrap.channel(NettyUtils.getServerSocketChannel());
        serverBootstrap.group(acceptGroups, workerGroups);
        serverBootstrap.option(ChannelOption.SO_BACKLOG, (Object)config.getBacklog());
        serverBootstrap.option(ChannelOption.SO_RCVBUF, (Object)config.getRcvBuf());
        serverBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)true);
        serverBootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)true);
        serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)false);
        serverBootstrap.childOption(ChannelOption.SO_LINGER, (Object)0);
        serverBootstrap.childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        serverBootstrap.childHandler(channelInitializer);
        return serverBootstrap;
    }
}

