/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.repository;

import com.tsi.app.common.utils.Counter;
import com.tsi.app.common.xnet.NettyUtils;
import com.tsi.comm.server.vo.TsiNodeVo;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsiSessionManager {
    private static final Logger log = LoggerFactory.getLogger(TsiSessionManager.class);
    public static final AttributeKey<TsiNodeVo> TSI_NODE_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"TsiNode");
    private static TsiSessionManager _instance = null;
    private volatile boolean serverRun;
    private Counter sessions = new Counter();
    private ConcurrentHashMap<Channel, TsiNodeVo> channelNodeMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TsiSessionManager getInstance() {
        if (_instance != null) return _instance;
        Class<TsiSessionManager> clazz = TsiSessionManager.class;
        synchronized (TsiSessionManager.class) {
            if (_instance != null) return _instance;
            _instance = new TsiSessionManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private TsiSessionManager() {
    }

    public int add() {
        return (int)this.sessions.increment();
    }

    public int remove() {
        return (int)this.sessions.decrement();
    }

    public int get() {
        return (int)this.sessions.get();
    }

    public void addChannel(Channel channel, TsiNodeVo vo) {
        this.channelNodeMap.put(channel, vo);
    }

    public void removeChannel(Channel channel) {
        this.channelNodeMap.remove(channel);
    }

    public TsiNodeVo getNodeVo(Channel channel) {
        return (TsiNodeVo)this.channelNodeMap.get(channel);
    }

    public void start() {
        this.serverRun = true;
    }

    public void stop() {
        this.serverRun = false;
    }

    public boolean isServerRun() {
        return this.serverRun;
    }

    public void reportChannelSessions() {
        log.info("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        log.info("Report Channel Sessions: {} Sessions.", (Object)this.sessions.get());
        log.info("{}", (Object)String.format("%10s %7s  Remote-Address", "ID", "Active"));
        log.info("----------------------------------------------------------------------------------------------------------------");
        for (Map.Entry obj : this.channelNodeMap.entrySet()) {
            Channel channel = (Channel)obj.getKey();
            TsiNodeVo node = (TsiNodeVo)obj.getValue();
            log.info("{}", (Object)String.format("%10s %7s  %s", node.getNodeId(), channel.isActive(), NettyUtils.getRemoteAddress((Channel)channel)));
        }
        log.info("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
    }
}

