/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.repository;

import com.tsi.app.common.app.AppUtils;
import com.tsi.app.common.xnet.NettyUtils;
import com.tsi.comm.server.mybatis.vo.AlarmOccrVo;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.vo.TsiAlarmConfigVo;
import com.tsi.comm.server.vo.TsiNodeVo;
import io.netty.channel.Channel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsiNodeManager {
    private static final Logger log = LoggerFactory.getLogger(TsiNodeManager.class);
    private static TsiNodeManager _instance = null;
    private ConcurrentHashMap<Long, TsiNodeVo> tsiNodeVoMap = new ConcurrentHashMap();
    private TsiCvimDbmsProcess tsiCvimDbmsService = (TsiCvimDbmsProcess)AppUtils.getBean(TsiCvimDbmsProcess.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TsiNodeManager getInstance() {
        if (_instance != null) return _instance;
        Class<TsiNodeManager> clazz = TsiNodeManager.class;
        synchronized (TsiNodeManager.class) {
            if (_instance != null) return _instance;
            _instance = new TsiNodeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    private TsiNodeManager() {
    }

    public TsiNodeVo get(long nodeId) {
        return (TsiNodeVo)this.tsiNodeVoMap.get(nodeId);
    }

    public void put(long nodeId, TsiNodeVo vo) {
        this.tsiNodeVoMap.put(nodeId, vo);
    }

    public int size() {
        return this.tsiNodeVoMap.size();
    }

    public boolean containsKey(long key) {
        return this.tsiNodeVoMap.containsKey(key);
    }

    public void beforeLoading() {
        for (Map.Entry obj : this.tsiNodeVoMap.entrySet()) {
            ((TsiNodeVo)obj.getValue()).setCheckInstalled(false);
        }
    }

    public void afterLoading() {
        for (Map.Entry obj : this.tsiNodeVoMap.entrySet()) {
            if (!((TsiNodeVo)obj.getValue()).isRegistered()) continue;
            ((TsiNodeVo)obj.getValue()).setInstalled(((TsiNodeVo)obj.getValue()).isCheckInstalled());
        }
    }

    public void reportNodeSessions() {
        log.info("================================================================================================================");
        log.info("Report Node Sessions: {} Nodes.", (Object)this.tsiNodeVoMap.size());
        int registered = 0;
        int unknown = 0;
        int connected = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+9"));
        log.info("{}", (Object)String.format("%10s %4s %7s %19s %19s %9s %6s %19s  Remote-Address", "ID", "UNTC", "Connect", "Connect Time", "Disconnect Time", "Connected", "Closed", "Last-Recv-Time"));
        log.info("----------------------------------------------------------------------------------------------------------------");
        for (Map.Entry obj : this.tsiNodeVoMap.entrySet()) {
            String info;
            String connect;
            TsiNodeVo node = (TsiNodeVo)obj.getValue();
            String check = node.isInstalled() ? "Y" : "N";
            check = check + (node.isSendNode() ? "Y" : "N");
            check = check + (node.isSendTest() ? "Y" : "N");
            check = check + (node.isSendCvim() ? "Y" : "N");
            if (node.isRegistered()) {
                ++registered;
            } else {
                ++unknown;
            }
            if (node.isConnect()) {
                ++connected;
                connect = "Y";
                info = NettyUtils.getRemoteAddress((Channel)node.getChannel());
            } else {
                connect = "N";
                info = "---";
            }
            String connectTm = sdf.format(new Date(node.getConnectTm()));
            String disconnectTm = sdf.format(new Date(node.getDisconnectTm()));
            String lastCommTm = sdf.format(new Date(node.getLastCommTm()));
            log.info("{}", (Object)String.format("%10s %4s %7s %19s %19s %9d %6d %19s  %s", node.getKey(), check, connect, connectTm, disconnectTm, node.getConnectCount().get(), node.getDisconnectCount().get(), lastCommTm, info));
        }
        log.info("----------------------------------------------------------------------------------------------------------------");
        log.info("Total Nodes: {} EA, Registered: {} EA, Unknown: {} EA, Connected: {} EA", new Object[]{this.tsiNodeVoMap.size(), registered, unknown, connected});
        log.info("==============================================");
    }

    public void checkSessionTimeout(long timeout) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+9"));
        long currTm = System.currentTimeMillis();
        for (Map.Entry obj : this.tsiNodeVoMap.entrySet()) {
            TsiNodeVo node = (TsiNodeVo)obj.getValue();
            if (!node.isConnect() || currTm - node.getLastCommTm() <= timeout) continue;
            try {
                AlarmOccrVo alarm = new AlarmOccrVo(4);
                alarm.setAlarmCode(TsiAlarmConfigVo.COMM_02);
                alarm.setAlarmTarget(node.getKey());
                alarm.setAlarmValue(NettyUtils.getRemoteIpAddress((Channel)node.getChannel()));
                this.tsiCvimDbmsService.add((Object)alarm, (int)Thread.currentThread().getId());
                String connectTm = sdf.format(new Date(node.getConnectTm()));
                String lastCommTm = sdf.format(new Date(node.getLastCommTm()));
                log.warn("Node: {}, Recv Timeout: Connect: {}, LastCommTime: {}", new Object[]{node.getKey(), connectTm, lastCommTm});
                node.getChannel().close();
            }
            catch (Exception e) {
                log.error("{}", (Object)e.getMessage());
            }
        }
    }
}

