/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server;

import com.tsi.comm.server.AppNameInitializer;
import com.tsi.comm.server.config.ApplicationConfig;
import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.kafka.KafkaConsumerService;
import com.tsi.comm.server.kafka.KafkaProducerService;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.process.logging.TsiCvimLoggingProcess;
import com.tsi.comm.server.process.packet.TsiCvimPacketProcess;
import com.tsi.comm.server.repository.ApplicationRepository;
import com.tsi.comm.server.service.TsiCommServerService;
import com.tsi.comm.server.tcp.TsiCvimServer;
import com.tsi.comm.server.vo.TsiAlarmConfigVo;
import com.tsi.comm.server.vo.mariadb.AlarmOccrVo;
import com.tsi.common.spring.SpringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@EnableTransactionManagement
@ComponentScan(basePackages={"com.tsi.common.spring", "com.tsi.comm.server.config", "com.tsi.comm.server"})
public class TsiCommServerApplication
implements CommandLineRunner,
ApplicationListener<ContextClosedEvent>,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(TsiCommServerApplication.class);
    public static final String APPLICATION_NAME = "tsi-comm-server";
    private String applicationName = "tsi-comm-server";
    private int serverId = 0;

    public static void main(String[] args) {
        SpringApplication application = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{TsiCommServerApplication.class}).listeners(new ApplicationListener[]{new ApplicationPidFileWriter("./conf/tsi-comm-server.pid")}).initializers(new ApplicationContextInitializer[]{new AppNameInitializer()}).build();
        application.setBannerMode(Banner.Mode.OFF);
        application.run(args);
    }

    public void run(String ... args) throws Exception {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.info("");
        log.info("");
        log.info("************************************************************************************");
        log.info("**                                                                                **");
        log.info("**                               TSI CVIM System                                  **");
        log.info("**                      CVIM Communication Server Program.                        **");
        log.info("**                                                                                **");
        log.info("**                                                                   [ver.1.0]    **");
        log.info("** startup: {}", (Object)sdfDate.format(new Date()));
        log.info("************************************************************************************");
        ApplicationConfig config = (ApplicationConfig)SpringUtils.getBean(ApplicationConfig.class);
        config.setStartSchedule(false);
        TsiCvimServerConfig serverConfig = (TsiCvimServerConfig)SpringUtils.getBean(TsiCvimServerConfig.class);
        this.serverId = serverConfig.getServerId();
        this.applicationName = "tsi-comm-server-" + this.serverId;
        ApplicationRepository.processStateVo.setProcessId(this.applicationName);
        TsiCommServerService tsiCommServerService = (TsiCommServerService)SpringUtils.getBean(TsiCommServerService.class);
        tsiCommServerService.init();
        KafkaConsumerService kafkaConsumerService = (KafkaConsumerService)SpringUtils.getBean(KafkaConsumerService.class);
        kafkaConsumerService.start();
        KafkaProducerService kafkaProducerService = (KafkaProducerService)SpringUtils.getBean(KafkaProducerService.class);
        kafkaProducerService.start();
        TsiCvimPacketProcess packetProcess = (TsiCvimPacketProcess)SpringUtils.getBean(TsiCvimPacketProcess.class);
        packetProcess.start();
        TsiCvimLoggingProcess loggingProcess = (TsiCvimLoggingProcess)SpringUtils.getBean(TsiCvimLoggingProcess.class);
        loggingProcess.start();
        TsiCvimDbmsProcess dbmsProcess = (TsiCvimDbmsProcess)SpringUtils.getBean(TsiCvimDbmsProcess.class);
        dbmsProcess.start();
        TsiCvimServer cvimServer = (TsiCvimServer)SpringUtils.getBean(TsiCvimServer.class);
        cvimServer.run();
        serverConfig.setStartup(true);
        try {
            AlarmOccrVo alarm = new AlarmOccrVo(4);
            alarm.setAlarmCode(TsiAlarmConfigVo.SYS_00);
            alarm.setAlarmTarget(this.applicationName);
            alarm.setAlarmValue("Running");
            tsiCommServerService.insertAlarmOccrHs(alarm);
            tsiCommServerService.updateProcessState(0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        config.setStartSchedule(true);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.error("on shutdown hook.");
            this.terminate();
        }));
    }

    public void terminate() {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.error("************************************************************************************");
        log.error("**    Application Terminated: {}", (Object)sdfDate.format(new Date()));
        try {
            TsiCvimServerConfig serverConfig = (TsiCvimServerConfig)SpringUtils.getBean(TsiCvimServerConfig.class);
            if (serverConfig != null) {
                serverConfig.setStartup(false);
            }
        }
        catch (Exception e) {
            log.error("**    Application.terminate:config: {}", (Object)e.getMessage());
        }
        try {
            TsiCvimServer cvimServer = (TsiCvimServer)SpringUtils.getBean(TsiCvimServer.class);
            if (cvimServer != null) {
                cvimServer.stop();
            }
        }
        catch (Exception e) {
            log.error("**    Application.terminate:cvimServer: {}", (Object)e.getMessage());
        }
        try {
            TsiCommServerService tsiCommServerService = (TsiCommServerService)SpringUtils.getBean(TsiCommServerService.class);
            if (tsiCommServerService != null) {
                tsiCommServerService.updateNodeStatusTerm(this.serverId);
                AlarmOccrVo alarm = new AlarmOccrVo(4);
                alarm.setAlarmCode(TsiAlarmConfigVo.SYS_00);
                alarm.setAlarmTarget(this.applicationName);
                alarm.setAlarmValue("Terminated");
                tsiCommServerService.insertAlarmOccrHs(alarm);
                tsiCommServerService.updateProcessState(2);
            }
        }
        catch (Exception e) {
            log.error("**    Application.terminate:updateProcessState: {}", (Object)e.getMessage());
        }
        try {
            KafkaProducerService kafkaProducerService = (KafkaProducerService)SpringUtils.getBean(KafkaProducerService.class);
            if (kafkaProducerService != null) {
                kafkaProducerService.shutdown();
            }
        }
        catch (Exception e) {
            log.error("**    Application.terminate:kafkaProducerService: {}", (Object)e.getMessage());
        }
        try {
            KafkaConsumerService kafkaConsumerService = (KafkaConsumerService)SpringUtils.getBean(KafkaConsumerService.class);
            if (kafkaConsumerService != null) {
                kafkaConsumerService.shutdown();
            }
        }
        catch (Exception e) {
            log.error("**    Application.terminate:kafkaConsumerService: {}", (Object)e.getMessage());
        }
        log.error("************************************************************************************");
    }

    public void onApplicationEvent(ContextClosedEvent contextClosedEvent) {
        log.error("{}", (Object)contextClosedEvent);
        this.terminate();
    }

    public void destroy() throws Exception {
        log.error("Application destroy.");
    }

    public void afterPropertiesSet() throws Exception {
    }
}

