/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.config;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@Configuration
@ConfigurationProperties(prefix="application.scheduling")
public class SchedulingConfig
implements SchedulingConfigurer {
    private static final Logger log = LoggerFactory.getLogger(SchedulingConfig.class);
    private int poolSize = 0;
    private final int MIN_POOL_SIZE = 10;
    private final int MAX_POOL_SIZE = 20;

    @PostConstruct
    private void init() {
        if (this.poolSize <= 0) {
            int availableProcessors = Runtime.getRuntime().availableProcessors();
            this.getClass();
            this.poolSize = Math.max(10, availableProcessors);
            this.getClass();
            this.poolSize = Math.min(this.poolSize, 20);
        }
        MDC.put((String)"filename", (String)"config");
        log.info("[SchedulingConfig] ------------");
        log.info("[SchedulingConfig] poolCore: {} EA.", (Object)this.poolSize);
        MDC.clear();
    }

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setPoolSize(this.poolSize);
        threadPoolTaskScheduler.setThreadNamePrefix("tsi-scheduler-");
        threadPoolTaskScheduler.initialize();
        scheduledTaskRegistrar.setTaskScheduler((TaskScheduler)threadPoolTaskScheduler);
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public int getMIN_POOL_SIZE() {
        this.getClass();
        return 10;
    }

    public int getMAX_POOL_SIZE() {
        this.getClass();
        return 20;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchedulingConfig)) {
            return false;
        }
        SchedulingConfig other = (SchedulingConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPoolSize() != other.getPoolSize()) {
            return false;
        }
        if (this.getMIN_POOL_SIZE() != other.getMIN_POOL_SIZE()) {
            return false;
        }
        return this.getMAX_POOL_SIZE() == other.getMAX_POOL_SIZE();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchedulingConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPoolSize();
        result = result * 59 + this.getMIN_POOL_SIZE();
        result = result * 59 + this.getMAX_POOL_SIZE();
        return result;
    }

    public String toString() {
        return "SchedulingConfig(poolSize=" + this.getPoolSize() + ", MIN_POOL_SIZE=" + this.getMIN_POOL_SIZE() + ", MAX_POOL_SIZE=" + this.getMAX_POOL_SIZE() + ")";
    }
}

