/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.config;

import com.tsi.comm.server.xnet.NettyServerConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="application.cvim-server")
public class TsiCvimServerConfig
extends NettyServerConfig {
    private static final Logger log = LoggerFactory.getLogger(TsiCvimServerConfig.class);
    private int serverId = 0;
    private int packetWorkers = 0;
    private int loggingWorkers = 0;
    private int dbmsWorkers = 0;
    private boolean checkPacket = true;
    private List<String> whiteListIps = new ArrayList();
    private Set<String> whiteListIpSet = new HashSet();
    private boolean startup = false;

    @PostConstruct
    private void init() {
        this.configure();
        int MAX_CORE = Math.max(8, Runtime.getRuntime().availableProcessors());
        if (this.packetWorkers == 0) {
            this.packetWorkers = MAX_CORE / 2;
        }
        if (this.loggingWorkers == 0) {
            this.loggingWorkers = MAX_CORE / 4;
        }
        if (this.dbmsWorkers == 0) {
            this.dbmsWorkers = MAX_CORE / 4;
        }
        if (this.getReaderIdleTimeSeconds() < 5) {
            this.setReaderIdleTimeSeconds(5);
        }
        this.whiteListIpSet = this.getWhitelistIpSet();
        MDC.put((String)"filename", (String)"config");
        log.info("[TsiCvimServerConfig] =======================================================");
        log.info("[TsiCvimServerConfig]              serverId: {}", (Object)this.serverId);
        log.info("[TsiCvimServerConfig]              MAX_CORE: {}", (Object)MAX_CORE);
        log.info("[TsiCvimServerConfig]         packetWorkers: {}", (Object)this.packetWorkers);
        log.info("[TsiCvimServerConfig]        loggingWorkers: {}", (Object)this.loggingWorkers);
        log.info("[TsiCvimServerConfig]           dbmsWorkers: {}", (Object)this.dbmsWorkers);
        log.info("[TsiCvimServerConfig]           checkPacket: {}", (Object)this.checkPacket);
        log.info("[TsiCvimServerConfig]        whiteListIpSet: {}", (Object)this.whiteListIpSet);
        log.info("[TsiCvimServerConfig] -------------------------");
        log.info("[TsiCvimServerConfig]           bindingAddr: {}", (Object)this.bindingAddr);
        log.info("[TsiCvimServerConfig]           bindingPort: {}", (Object)this.bindingPort);
        log.info("[TsiCvimServerConfig]               backlog: {}", (Object)this.backlog);
        log.info("[TsiCvimServerConfig]         acceptThreads: {}", (Object)this.acceptThreads);
        log.info("[TsiCvimServerConfig]         workerThreads: {}", (Object)this.workerThreads);
        log.info("[TsiCvimServerConfig]                rcvBuf: {}", (Object)this.rcvBuf);
        log.info("[TsiCvimServerConfig]                sndBuf: {}", (Object)this.sndBuf);
        log.info("[TsiCvimServerConfig] readerIdleTimeSeconds: {}", (Object)this.readerIdleTimeSeconds);
        log.info("[TsiCvimServerConfig] writerIdleTimeSeconds: {}", (Object)this.writerIdleTimeSeconds);
        log.info("[TsiCvimServerConfig]    allIdleTimeSeconds: {}", (Object)this.allIdleTimeSeconds);
        log.info("[TsiCvimServerConfig] connectTimeoutSeconds: {}", (Object)this.connectTimeoutSeconds);
        log.info("[TsiCvimServerConfig] =======================================================");
        MDC.clear();
    }

    public Set<String> getWhitelistIpSet() {
        if (this.whiteListIps == null) {
            return Collections.emptySet();
        }
        return new HashSet<String>(this.whiteListIps);
    }

    public boolean isInWhitelistIps(String ip) {
        return this.whiteListIpSet.contains(ip);
    }

    public int getServerId() {
        return this.serverId;
    }

    public int getPacketWorkers() {
        return this.packetWorkers;
    }

    public int getLoggingWorkers() {
        return this.loggingWorkers;
    }

    public int getDbmsWorkers() {
        return this.dbmsWorkers;
    }

    public boolean isCheckPacket() {
        return this.checkPacket;
    }

    public List<String> getWhiteListIps() {
        return this.whiteListIps;
    }

    public boolean isStartup() {
        return this.startup;
    }

    public void setServerId(int serverId) {
        this.serverId = serverId;
    }

    public void setPacketWorkers(int packetWorkers) {
        this.packetWorkers = packetWorkers;
    }

    public void setLoggingWorkers(int loggingWorkers) {
        this.loggingWorkers = loggingWorkers;
    }

    public void setDbmsWorkers(int dbmsWorkers) {
        this.dbmsWorkers = dbmsWorkers;
    }

    public void setCheckPacket(boolean checkPacket) {
        this.checkPacket = checkPacket;
    }

    public void setWhiteListIps(List<String> whiteListIps) {
        this.whiteListIps = whiteListIps;
    }

    public void setWhiteListIpSet(Set<String> whiteListIpSet) {
        this.whiteListIpSet = whiteListIpSet;
    }

    public void setStartup(boolean startup) {
        this.startup = startup;
    }
}

