/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.config;

import com.tsi.comm.server.xnet.NetUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.apache.kafka.common.serialization.LongDeserializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="application.kafka.producer")
public class TsiKafkaProducerConfig {
    private static final Logger log = LoggerFactory.getLogger(TsiKafkaProducerConfig.class);
    public static final String CVIM_RAW_TOPIC = "cvim-raw";
    public static final String TEST_TOPIC = "topic-for-ssd-test";
    public static final String CVIM_PING = "cvim_ping";
    private String consumerGroupId = "tsi-comm-server";
    private String consumerAckConfig = "1";
    private boolean multiConnect = false;
    private String bootstrapServers;
    private List<Map<String, String>> props = new ArrayList();
    private String cvimServers = "";
    private String nodeServers = "";
    private String testServers = "";
    private boolean enableCvim = true;
    private boolean enableNode = true;
    private boolean enableTest = true;

    @PostConstruct
    private void init() {
        if (this.cvimServers.isEmpty()) {
            this.cvimServers = this.bootstrapServers;
        }
        if (this.nodeServers.isEmpty()) {
            this.nodeServers = this.bootstrapServers;
        }
        if (this.testServers.isEmpty()) {
            this.testServers = this.bootstrapServers;
        }
        MDC.put((String)"filename", (String)"config");
        log.info("[TsiKafkaProducerConfig] --------------------");
        log.info("[TsiKafkaProducerConfig]     multiConnect: {}", (Object)this.multiConnect);
        log.info("[TsiKafkaProducerConfig] bootstrapServers: {}", (Object)this.bootstrapServers);
        log.info("[TsiKafkaProducerConfig]            props: {}", this.props.toArray());
        log.info("[TsiKafkaProducerConfig]      cvimServers: {}", (Object)this.cvimServers);
        log.info("[TsiKafkaProducerConfig]      nodeServers: {}", (Object)this.nodeServers);
        log.info("[TsiKafkaProducerConfig]      testServers: {}", (Object)this.testServers);
        log.info("[TsiKafkaProducerConfig]       enableCvim: {}", (Object)this.enableCvim);
        log.info("[TsiKafkaProducerConfig]       enableNode: {}", (Object)this.enableNode);
        log.info("[TsiKafkaProducerConfig]       enableTest: {}", (Object)this.enableTest);
        MDC.clear();
    }

    public String getGroupId() {
        return this.consumerGroupId + "-" + NetUtils.getHostName();
    }

    public Map<String, Object> getConsumerPropertiesMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("bootstrap.servers", this.bootstrapServers);
        properties.put("group.id", this.getGroupId());
        properties.put("enable.auto.commit", "true");
        properties.put("auto.commit.interval.ms", 1);
        properties.put("session.timeout.ms", "10000");
        properties.put("auto.offset.reset", "latest");
        properties.put("max.poll.interval.ms", "100");
        properties.put("check.crcs", false);
        properties.put("max.poll.records", 1);
        properties.put("key.deserializer", StringDeserializer.class);
        properties.put("value.deserializer", LongDeserializer.class);
        return properties;
    }

    public String getConsumerGroupId() {
        return this.consumerGroupId;
    }

    public String getConsumerAckConfig() {
        return this.consumerAckConfig;
    }

    public boolean isMultiConnect() {
        return this.multiConnect;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public List<Map<String, String>> getProps() {
        return this.props;
    }

    public String getCvimServers() {
        return this.cvimServers;
    }

    public String getNodeServers() {
        return this.nodeServers;
    }

    public String getTestServers() {
        return this.testServers;
    }

    public boolean isEnableCvim() {
        return this.enableCvim;
    }

    public boolean isEnableNode() {
        return this.enableNode;
    }

    public boolean isEnableTest() {
        return this.enableTest;
    }

    public void setConsumerGroupId(String consumerGroupId) {
        this.consumerGroupId = consumerGroupId;
    }

    public void setConsumerAckConfig(String consumerAckConfig) {
        this.consumerAckConfig = consumerAckConfig;
    }

    public void setMultiConnect(boolean multiConnect) {
        this.multiConnect = multiConnect;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public void setProps(List<Map<String, String>> props) {
        this.props = props;
    }

    public void setCvimServers(String cvimServers) {
        this.cvimServers = cvimServers;
    }

    public void setNodeServers(String nodeServers) {
        this.nodeServers = nodeServers;
    }

    public void setTestServers(String testServers) {
        this.testServers = testServers;
    }

    public void setEnableCvim(boolean enableCvim) {
        this.enableCvim = enableCvim;
    }

    public void setEnableNode(boolean enableNode) {
        this.enableNode = enableNode;
    }

    public void setEnableTest(boolean enableTest) {
        this.enableTest = enableTest;
    }
}

