/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.kafka;

import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.config.TsiKafkaProducerConfig;
import com.tsi.comm.server.kafka.TsiKafkaConsumerWorker;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.repository.TsiTpmsManager;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;
import org.springframework.kafka.listener.ConcurrentMessageListenerContainer;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.stereotype.Service;

@Service
public class KafkaConsumerService {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumerService.class);
    private final TsiCvimServerConfig config;
    private final TsiKafkaProducerConfig producerConfig;
    private final TsiTpmsManager tpmsManager;
    private final TsiCvimDbmsProcess dbmsProcess;
    private ConcurrentMessageListenerContainer<String, Long> kafkaListenerContainer = null;

    public void start() {
        if (this.kafkaListenerContainer != null) {
            if (!this.kafkaListenerContainer.isRunning()) {
                log.warn("kafkaListenerContainer restart");
                this.kafkaListenerContainer.start();
            }
            return;
        }
        ContainerProperties containerProperties = new ContainerProperties(new String[]{"cvim_ping" + this.config.getServerId()});
        containerProperties.setGroupId(this.producerConfig.getGroupId());
        containerProperties.setPollTimeout(5000L);
        containerProperties.setMessageListener((Object)new TsiKafkaConsumerWorker(this.tpmsManager, this.dbmsProcess));
        containerProperties.setConsumerRebalanceListener((ConsumerRebalanceListener)new /* Unavailable Anonymous Inner Class!! */);
        DefaultKafkaConsumerFactory consumerFactory = new DefaultKafkaConsumerFactory(this.producerConfig.getConsumerPropertiesMap());
        this.kafkaListenerContainer = new ConcurrentMessageListenerContainer((ConsumerFactory)consumerFactory, containerProperties);
        this.kafkaListenerContainer.setBeanName("consumer");
        this.kafkaListenerContainer.setConcurrency(1);
        this.kafkaListenerContainer.setErrorHandler((thrownException, data) -> {
            log.error("kafkaListenerContainer error: {}", (Object)thrownException.getMessage());
            this.kafkaListenerContainer.stop();
        });
        this.kafkaListenerContainer.start();
    }

    public void shutdown() {
        try {
            if (this.kafkaListenerContainer != null) {
                this.kafkaListenerContainer.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public KafkaConsumerService(TsiCvimServerConfig config, TsiKafkaProducerConfig producerConfig, TsiTpmsManager tpmsManager, TsiCvimDbmsProcess dbmsProcess) {
        this.config = config;
        this.producerConfig = producerConfig;
        this.tpmsManager = tpmsManager;
        this.dbmsProcess = dbmsProcess;
    }
}

