/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.kafka;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

public class KafkaProducerFactory {
    public static <K, V> KafkaTemplate<K, V> createByteArrayTemplate(String bootstrapServers, List<Map<String, String>> props) {
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put("bootstrap.servers", bootstrapServers);
        configs.put("enable.idempotence", false);
        configs.put("acks", "0");
        configs.put("retries", 0);
        configs.put("linger.ms", 0);
        configs.put("compression.type", "none");
        configs.put("request.timeout.ms", 3000);
        configs.put("delivery.timeout.ms", 4000);
        configs.put("transaction.timeout.ms", 5000);
        configs.put("key.serializer", StringSerializer.class);
        configs.put("value.serializer", ByteArraySerializer.class);
        for (Map<String, String> prop : props) {
            for (Map.Entry<String, String> elem : prop.entrySet()) {
                String key = elem.getKey();
                String val = elem.getValue();
                if (val == null) continue;
                if (val.equals("true") || val.equals("false")) {
                    configs.put(key, val.equals("true"));
                    continue;
                }
                configs.put(key, val);
            }
        }
        DefaultKafkaProducerFactory defaultKafkaProducerFactory = new DefaultKafkaProducerFactory(configs);
        return new KafkaTemplate((ProducerFactory)defaultKafkaProducerFactory);
    }

    public static <K, V> KafkaTemplate<K, V> createProducerTemplate(Map<String, Object> props) {
        DefaultKafkaProducerFactory defaultKafkaProducerFactory = new DefaultKafkaProducerFactory(props);
        return new KafkaTemplate((ProducerFactory)defaultKafkaProducerFactory);
    }

    public static Properties getProperties(String bootstrapServers, List<Map<String, String>> props) {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", bootstrapServers);
        properties.put("enable.idempotence", (Object)false);
        properties.put("acks", "0");
        properties.put("retries", (Object)0);
        properties.put("linger.ms", (Object)0);
        properties.put("compression.type", "none");
        properties.put("request.timeout.ms", (Object)3000);
        properties.put("delivery.timeout.ms", (Object)4000);
        properties.put("transaction.timeout.ms", (Object)5000);
        properties.put("key.serializer", StringSerializer.class);
        properties.put("value.serializer", ByteArraySerializer.class);
        for (Map<String, String> prop : props) {
            for (Map.Entry<String, String> elem : prop.entrySet()) {
                String key = elem.getKey();
                String val = elem.getValue();
                if (val == null) continue;
                if (val.equals("true") || val.equals("false")) {
                    properties.put(key, (Object)val.equals("true"));
                    continue;
                }
                properties.put(key, val);
            }
        }
        return properties;
    }
}

