/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.process.logging;

import com.tsi.comm.server.process.AbstractTsiCvimWorker;
import com.tsi.comm.server.protocol.AbstractTsiPacket;
import com.tsi.comm.server.protocol.TsiCpuPacket;
import com.tsi.common.utils.TimeUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TsiCvimLoggingWorker
extends AbstractTsiCvimWorker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(TsiCvimLoggingWorker.class);
    public static final AbstractTsiPacket SHUTDOWN_PACKET = new TsiCpuPacket(-1L, 0L, 0L, 0L, 0);
    private final LinkedBlockingQueue<AbstractTsiPacket> DATA_QUEUE;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public TsiCvimLoggingWorker(int idx, int qSize) {
        this.idx = idx;
        this.qSize = qSize;
        this.DATA_QUEUE = new LinkedBlockingQueue(qSize);
        this.sdf.setTimeZone(TimeZone.getTimeZone("GMT+9"));
    }

    @Override
    public void run() {
        log.info("LoggingWorker({}): {} Start. QSIZE: {}", new Object[]{this.idx, Thread.currentThread().getName(), this.qSize});
        try {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    AbstractTsiPacket packet = (AbstractTsiPacket)this.DATA_QUEUE.take();
                    if (packet == SHUTDOWN_PACKET) {
                        log.info("LoggingWorker({}): Shutdown signal received. Exiting...", (Object)this.idx);
                        break;
                    }
                    this.process((Object)packet);
                }
                catch (InterruptedException ie) {
                    log.warn("LoggingWorker({}): {} Interrupted. Exiting...", (Object)this.idx, (Object)Thread.currentThread().getName());
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    log.error("LoggingWorker({}): {} Exception: {}", new Object[]{this.idx, Thread.currentThread().getName(), e.getMessage()});
                }
            }
        }
        finally {
            log.info("LoggingWorker({}): {} Stopped.", (Object)this.idx, (Object)Thread.currentThread().getName());
        }
    }

    public boolean add(Object object) {
        boolean offer = false;
        AbstractTsiPacket packet = (AbstractTsiPacket)object;
        try {
            offer = this.DATA_QUEUE.offer(packet);
            if (!offer) {
                MDC.put((String)"id", (String)Long.toString(packet.getNodeId()));
                log.error("LoggingWorker({}): Queue.offer(Full): {}, {}/{}/{}, {}, {}", new Object[]{this.idx, packet.getNodeId(), this.DATA_QUEUE.size(), this.qSize, this.DATA_QUEUE.remainingCapacity(), TimeUtils.elapsedTime((long)packet.getRcv()), Thread.currentThread().getName()});
                MDC.clear();
            }
        }
        catch (Exception e) {
            MDC.put((String)"id", (String)Long.toString(packet.getNodeId()));
            log.error("LoggingWorker({}): Queue.offer: Exception: {}, {}, {}", new Object[]{this.idx, packet.getNodeId(), Thread.currentThread().getName(), e.getMessage()});
            MDC.clear();
        }
        return offer;
    }

    public void process(Object object) {
        AbstractTsiPacket packet = (AbstractTsiPacket)object;
        long job = packet.getEnd() - packet.getRcv();
        Date date = new Date(packet.getTimespec().times() * 1000L);
        String collectTime = this.sdf.format(date);
        MDC.put((String)"id", (String)Long.toString(packet.getNodeId()));
        log.info("{} Node: {},        Job: {} {}, {} bytes, Average {}", new Object[]{collectTime, packet.getNodeId(), TimeUtils.elapsedTimeStr((long)job), Thread.currentThread().getName(), packet.getPacketLength(), TimeUtils.elapsedTimeStr((long)packet.getAvg())});
        MDC.clear();
        this.calcProcessTime(packet.getRcv());
    }

    public void report() {
        log.info("LoggingWorker({}), Queue Total/Size/Remain: {}/{}/{}, Average: {}, {}", new Object[]{this.idx, this.qSize, this.DATA_QUEUE.size(), this.DATA_QUEUE.remainingCapacity(), TimeUtils.elapsedTimeStr((long)this.avgTime), Thread.currentThread().getName()});
    }

    public LinkedBlockingQueue<AbstractTsiPacket> getDATA_QUEUE() {
        return this.DATA_QUEUE;
    }

    public SimpleDateFormat getSdf() {
        return this.sdf;
    }
}

