/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.process.packet;

import com.tsi.comm.server.protocol.TsiCpuPacket;
import com.tsi.comm.server.vo.TsiNodeVo;
import com.tsi.common.utils.SysUtils;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class TsiChannelSession {
    private static final Logger log = LoggerFactory.getLogger(TsiChannelSession.class);

    private TsiChannelSession() {
    }

    public static void initChannel(TsiNodeVo nodeVo, String remoteIpAddress) {
        try {
            if (nodeVo != null) {
                String logKey = nodeVo.getKey();
                MDC.put((String)"id", (String)logKey);
                log.info("Node: {},     initChannel, Connects: {}, {}", new Object[]{nodeVo.getNodeId(), nodeVo.getConnectCount().get(), remoteIpAddress});
                MDC.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sessionActive(TsiNodeVo nodeVo, String remoteIpAddress) {
        try {
            if (nodeVo != null) {
                String logKey = nodeVo.getKey();
                MDC.put((String)"id", (String)logKey);
                log.info("Node: {},   sessionActive, Connects: {}, {}", new Object[]{nodeVo.getNodeId(), nodeVo.getConnectCount().get(), remoteIpAddress});
                MDC.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sessionInactive(TsiNodeVo nodeVo, String remoteIpAddress) {
        try {
            if (nodeVo != null) {
                String logKey = nodeVo.getKey();
                MDC.put((String)"id", (String)logKey);
                log.info("Node: {}, sessionInactive, Connects: {}, {}", new Object[]{nodeVo.getNodeId(), nodeVo.getConnectCount().get(), remoteIpAddress});
                MDC.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void objectRegistered(TsiNodeVo nodeVo, String remoteIpAddress) {
        try {
            if (nodeVo != null) {
                String logKey = nodeVo.getKey();
                MDC.put((String)"id", (String)logKey);
                log.info("Node: {},   objRegistered, Connects: {}, {}", new Object[]{nodeVo.getNodeId(), nodeVo.getConnectCount().get(), remoteIpAddress});
                MDC.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sessionTimeout(TsiNodeVo nodeVo, String remoteIpAddress) {
        try {
            if (nodeVo != null) {
                String logKey = nodeVo.getKey();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                sdf.setTimeZone(TimeZone.getTimeZone("GMT+9"));
                String lastCommTm = sdf.format(new Date(nodeVo.getLastCommTm()));
                MDC.put((String)"id", (String)logKey);
                log.info("Node: {},  sessionTimeout, Connects: {}, {}, {}", new Object[]{nodeVo.getNodeId(), nodeVo.getConnectCount().get(), remoteIpAddress, lastCommTm});
                MDC.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void recvPacketDump(TsiNodeVo nodeVo, TsiCpuPacket packet) {
        try {
            if (nodeVo != null) {
                String logKey = nodeVo.getKey();
                MDC.put((String)"id", (String)logKey);
                byte[] buf = packet.getBuf();
                if (buf == null || buf.length == 0) {
                    log.info("RECV: {}, null bytes.", (Object)nodeVo.getNodeId());
                } else {
                    log.info("RECV: {}, {} bytes, {}", new Object[]{nodeVo.getNodeId(), buf.length, SysUtils.byteArrayToHex((byte[])packet.getBuf())});
                }
                MDC.clear();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void recvPacketDump(String logKey, ByteBuf byteBuf) {
        try {
            MDC.put((String)"id", (String)logKey);
            if (byteBuf == null || !byteBuf.isReadable()) {
                log.info("RECV: {}, null or empty buffer.", (Object)logKey);
            } else {
                log.info("RECV: {}, {} bytes.\n{}", new Object[]{logKey, byteBuf.readableBytes(), ByteBufUtil.prettyHexDump((ByteBuf)byteBuf)});
            }
            MDC.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

