/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.protocol;

import com.tsi.common.utils.HexString;
import com.tsi.common.utils.Timespec;

public abstract class AbstractTsiPacket {
    protected Timespec timespec;
    protected long add;
    protected long pop;
    protected long par;
    protected long end;
    protected long avg;
    protected long nodeId;
    protected long remoteIp;
    protected int remotePort;
    protected int opCode;
    protected byte[] buf;

    public AbstractTsiPacket(long nodeId, long sec, long nsec, long remoteIpAddr, int remotePort) {
        this.timespec = new Timespec(sec, nsec);
        this.nodeId = nodeId;
        this.remoteIp = remoteIpAddr;
        this.remotePort = remotePort;
        this.end = 0L;
    }

    public int getPacketLength() {
        return this.buf == null ? 0 : this.buf.length;
    }

    public String getHexString() {
        return HexString.fromBytes((byte[])this.buf);
    }

    public long getRcv() {
        return this.timespec.timestamp();
    }

    public abstract byte[] getCvimData();

    public abstract byte[] getTestData();

    public abstract byte[] getNodeData();

    public Timespec getTimespec() {
        return this.timespec;
    }

    public long getAdd() {
        return this.add;
    }

    public long getPop() {
        return this.pop;
    }

    public long getPar() {
        return this.par;
    }

    public long getEnd() {
        return this.end;
    }

    public long getAvg() {
        return this.avg;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public long getRemoteIp() {
        return this.remoteIp;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public int getOpCode() {
        return this.opCode;
    }

    public byte[] getBuf() {
        return this.buf;
    }

    public void setTimespec(Timespec timespec) {
        this.timespec = timespec;
    }

    public void setAdd(long add) {
        this.add = add;
    }

    public void setPop(long pop) {
        this.pop = pop;
    }

    public void setPar(long par) {
        this.par = par;
    }

    public void setEnd(long end) {
        this.end = end;
    }

    public void setAvg(long avg) {
        this.avg = avg;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public void setRemoteIp(long remoteIp) {
        this.remoteIp = remoteIp;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public void setOpCode(int opCode) {
        this.opCode = opCode;
    }

    public void setBuf(byte[] buf) {
        this.buf = buf;
    }
}

