/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.protocol;

import com.tsi.comm.server.dto.TsiCvimAbnormal;
import com.tsi.comm.server.dto.TsiCvimControl;
import com.tsi.comm.server.dto.TsiCvimStatus;
import com.tsi.comm.server.dto.mongodb.TcsNodeStatus;
import com.tsi.comm.server.protocol.AbstractTsiPacket;
import com.tsi.comm.server.protocol.TsiCpuAddPacket;
import com.tsi.comm.server.protocol.enums.eLightsStatus;
import com.tsi.comm.server.protocol.enums.eLightsType;
import com.tsi.comm.server.protocol.enums.eOpCode;
import com.tsi.comm.server.protocol.enums.eTimeReliability;
import com.tsi.comm.server.repository.TsiAlarmManager;
import com.tsi.comm.server.repository.TsiNodeAddManager;
import com.tsi.comm.server.vo.TsiNodeAddDetailVo;
import com.tsi.comm.server.vo.TsiNodeAddVo;
import com.tsi.comm.server.vo.TsiNodeVo;
import com.tsi.common.utils.ByteUtils;
import com.tsi.common.utils.CRC16Utils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsiCpuPacket
extends AbstractTsiPacket {
    private static final Logger log = LoggerFactory.getLogger(TsiCpuPacket.class);
    protected static TsiNodeAddManager nodeAddManager;
    protected static TsiAlarmManager alarmAddManager;
    private Object obj;
    private int length;
    private byte dataVer;
    private int count;
    protected byte[] cvimData;
    protected byte[] nodeData;
    protected List<TsiCpuAddPacket> addNodes;

    public static void setNodeAddManager(TsiNodeAddManager nodeAddManager, TsiAlarmManager alarmAddManager) {
        TsiCpuPacket.nodeAddManager = nodeAddManager;
        TsiCpuPacket.alarmAddManager = alarmAddManager;
    }

    public TsiCpuPacket(long nodeId, long msec, long nsec, long remoteIpAddress, int remotePort) {
        super(nodeId, msec, nsec, remoteIpAddress, remotePort);
        this.setOpCode(eOpCode.TSI_CPU_SIGNAL_NOTIFY.getValue());
    }

    protected byte getStx1() {
        if (this.buf != null) {
            return this.buf[0];
        }
        return 0;
    }

    protected byte getStx2() {
        if (this.buf != null) {
            return this.buf[1];
        }
        return 0;
    }

    public byte[] getTestData() {
        return this.buf;
    }

    protected void makeCvimPacket() {
        int packetLength = this.buf == null ? 0 : this.buf.length;
        this.cvimData = new byte[27 + packetLength];
        System.arraycopy(this.timespec.bytes(), 0, this.cvimData, 0, 16);
        ByteUtils.setUnsignedInt((byte[])this.cvimData, (int)16, (long)this.getRemoteIp());
        ByteUtils.setUnsignedShort((byte[])this.cvimData, (int)20, (int)this.getRemotePort());
        this.cvimData[22] = this.opCode == (byte)eOpCode.TSI_CPU_SIGNAL_NOTIFY.getValue() ? (byte)1 : 0;
        ByteUtils.setUnsignedInt((byte[])this.cvimData, (int)23, (long)this.nodeId);
        if (packetLength > 0) {
            System.arraycopy(this.buf, 0, this.cvimData, 27, packetLength);
        }
    }

    protected void makeAddNodeCvimPaket(TsiCpuPacket cpuPacket, byte[] packet) {
        int packetLength = packet == null ? 0 : packet.length;
        int headSize = 33;
        cpuPacket.cvimData = new byte[33 + packetLength + 2];
        System.arraycopy(this.timespec.bytes(), 0, cpuPacket.cvimData, 0, 16);
        ByteUtils.setUnsignedInt((byte[])cpuPacket.cvimData, (int)16, (long)this.getRemoteIp());
        ByteUtils.setUnsignedShort((byte[])cpuPacket.cvimData, (int)20, (int)this.getRemotePort());
        cpuPacket.cvimData[22] = this.opCode == (byte)eOpCode.TSI_CPU_SIGNAL_NOTIFY.getValue() ? (byte)1 : 0;
        ByteUtils.setUnsignedInt((byte[])cpuPacket.cvimData, (int)23, (long)cpuPacket.nodeId);
        cpuPacket.cvimData[27] = this.getStx1();
        cpuPacket.cvimData[28] = this.getStx2();
        ByteUtils.setUnsignedShort((byte[])cpuPacket.cvimData, (int)29, (int)(packetLength + 2));
        cpuPacket.cvimData[31] = (byte)this.getOpCode();
        cpuPacket.cvimData[32] = this.getDataVer();
        if (packetLength > 0) {
            System.arraycopy(packet, 0, cpuPacket.cvimData, 33, packetLength);
        }
    }

    protected int checkPacket(TsiNodeVo obj, boolean isCheckCrcError) {
        int calculatedCrc;
        if (this.buf == null) {
            log.error("parsing: errno(-1), NodeId: {}, buf==null", (Object)this.nodeId);
            return -2;
        }
        if (this.buf[0] != 126 || this.buf[1] != 126) {
            alarmAddManager.reportPacketError(Long.valueOf(this.nodeId), this.buf, "STX", this.buf[0] & 0xFF, this.buf[1] & 0xFF);
            log.error("parsing: errno(-3), NodeId: {}, stx1: {}, stx2: {}", new Object[]{this.nodeId, this.buf[0], this.buf[1]});
            return -3;
        }
        int reqLength = 18 + 5 * this.count;
        if (this.length < reqLength) {
            alarmAddManager.reportPacketError(Long.valueOf(this.nodeId), this.buf, "LENGTH", reqLength, this.length);
            log.error("parsing: errno(-4), NodeId: {}, reqLength: {}, recvLength: {}", new Object[]{this.nodeId, reqLength, this.length});
            return -4;
        }
        int reqPacketLength = reqLength + 2;
        if (this.buf.length < reqPacketLength) {
            alarmAddManager.reportPacketError(Long.valueOf(this.nodeId), this.buf, "PACKET_LENGTH", reqPacketLength, this.buf.length);
            log.error("parsing: errno(-5), NodeId: {}, Packet reqLength: {}, recvLength: {}", new Object[]{this.nodeId, reqPacketLength, this.buf.length});
            return -5;
        }
        int receivedCrc = ByteUtils.getUnsignedShort((byte[])this.buf, (int)(this.buf.length - 2));
        if (receivedCrc != (calculatedCrc = CRC16Utils.CRC16_ccitt_cvim((byte[])this.buf, (int)2, (int)(this.length - 2)))) {
            alarmAddManager.reportCrcError(Long.valueOf(this.nodeId), this.buf, receivedCrc, calculatedCrc);
            if (isCheckCrcError || obj != null && obj.isDump()) {
                log.error("parsing: errno(-9), NodeId: {}, crc(recv/calc): {}/{}", new Object[]{this.nodeId, receivedCrc, calculatedCrc});
            }
            return isCheckCrcError ? -9 : 0;
        }
        return 0;
    }

    public int parsing(TsiNodeVo obj, boolean isCheckCrcError) {
        int indexStatusCount = 13;
        if (this.buf == null || this.buf.length < 13) {
            log.error("parsing: errno(-1), NodeId: {}, buf==null: {}, length: {}", new Object[]{this.nodeId, this.buf == null, this.buf == null ? 0 : this.buf.length});
            return -1;
        }
        this.length = ByteUtils.getUnsignedShort((byte[])this.buf, (int)2);
        this.opCode = this.buf[4];
        this.dataVer = this.buf[5];
        this.count = this.buf[13] & 0x7F;
        obj.setSigCount(this.count);
        int result = this.checkPacket(obj, isCheckCrcError);
        if (0 != result) {
            return result;
        }
        this.makeCvimPacket();
        TsiNodeAddVo tsiNodeAddVo = nodeAddManager.get(this.nodeId);
        if (tsiNodeAddVo == null) {
            int addLength = this.buf.length - 8;
            int r25Length = 12 + this.count * 5;
            if (addLength > r25Length) {
                addLength = r25Length;
            }
            this.nodeData = new byte[addLength];
            System.arraycopy(this.buf, 6, this.nodeData, 0, addLength);
            return 0;
        }
        byte[] head = new byte[12];
        ArrayList<byte[]> nodeStatus = new ArrayList<byte[]>();
        HashMap addStatus = new HashMap();
        System.arraycopy(this.buf, 6, head, 0, 12);
        int ii = 18;
        for (int loop = 0; loop < this.count; ++loop) {
            byte[] status = new byte[5];
            System.arraycopy(this.buf, ii, status, 0, 5);
            int dirAdd = status[0] & 0xF;
            if (dirAdd == 0) {
                nodeStatus.add(status);
            } else {
                int originDirCode = status[4];
                int direction = originDirCode / 10;
                int addNodeIdx = originDirCode % 10;
                if (addNodeIdx > 4) {
                    dirAdd = addNodeIdx - 4;
                    originDirCode = direction * 10;
                }
                status[0] = (byte)(status[0] & 0xF0);
                TsiNodeAddDetailVo detailVo = (TsiNodeAddDetailVo)tsiNodeAddVo.getAddNodeMap().get(originDirCode * 1000 + dirAdd);
                if (detailVo != null && detailVo.getAddDirCode() != null) {
                    for (int dirIdx = 0; dirIdx < detailVo.getAddDirCode().length; ++dirIdx) {
                        ArrayList<byte[]> list = (ArrayList<byte[]>)addStatus.get(detailVo.getNodeId());
                        if (list == null) {
                            list = new ArrayList<byte[]>();
                            addStatus.put(detailVo.getNodeId(), list);
                        }
                        if (dirIdx == 0) {
                            status[4] = detailVo.getAddDirCode()[dirIdx];
                            list.add(status);
                            continue;
                        }
                        byte[] status2 = new byte[5];
                        System.arraycopy(status, 0, status2, 0, 5);
                        status2[4] = detailVo.getAddDirCode()[dirIdx];
                        list.add(status2);
                    }
                }
            }
            ii += 5;
        }
        int splitFlag = 1;
        int statusCount = nodeStatus.size();
        this.nodeData = new byte[12 + statusCount * 5];
        System.arraycopy(head, 0, this.nodeData, 0, 12);
        this.nodeData[7] = (byte)(statusCount | splitFlag << 7);
        for (int ii2 = 0; ii2 < statusCount; ++ii2) {
            System.arraycopy(nodeStatus.get(ii2), 0, this.nodeData, 12 + ii2 * 5, 5);
        }
        this.makeAddNodeCvimPaket(this, this.nodeData);
        if (addStatus.isEmpty()) {
            return 0;
        }
        this.addNodes = new ArrayList();
        for (Map.Entry entry : addStatus.entrySet()) {
            statusCount = ((List)entry.getValue()).size();
            TsiCpuAddPacket addPacket = new TsiCpuAddPacket(((Long)entry.getKey()).longValue(), this.timespec, this.remoteIp, this.remotePort);
            addPacket.setObj((Object)nodeAddManager.get(((Long)entry.getKey()).longValue()));
            addPacket.setNodeData(new byte[12 + statusCount * 5]);
            System.arraycopy(head, 0, addPacket.getNodeData(), 0, 12);
            ByteUtils.setUnsignedInt((byte[])addPacket.getNodeData(), (int)0, (long)((Long)entry.getKey()));
            addPacket.getNodeData()[7] = (byte)(statusCount | splitFlag << 7);
            for (int ii3 = 0; ii3 < statusCount; ++ii3) {
                System.arraycopy(((List)entry.getValue()).get(ii3), 0, addPacket.getNodeData(), 12 + ii3 * 5, 5);
            }
            this.makeAddNodeCvimPaket((TsiCpuPacket)addPacket, addPacket.getNodeData());
            this.addNodes.add(addPacket);
        }
        return 0;
    }

    public TcsNodeStatus getNodeStatus() {
        int nodeLength = this.buf.length - 27;
        byte[] msec = new byte[8];
        byte[] nsec = new byte[8];
        System.arraycopy(this.cvimData, 0, msec, 0, 8);
        System.arraycopy(this.cvimData, 8, nsec, 0, 8);
        ByteBuffer byteMSec = ByteBuffer.wrap(msec);
        ByteBuffer byteNSec = ByteBuffer.wrap(nsec);
        byteMSec.order(ByteOrder.LITTLE_ENDIAN);
        byteNSec.order(ByteOrder.LITTLE_ENDIAN);
        long milliSeconds = byteMSec.getLong();
        long nanoSeconds = byteNSec.getLong();
        this.remoteIp = ByteUtils.getUnsignedInt((byte[])this.cvimData, (int)16);
        this.remotePort = ByteUtils.getUnsignedShort((byte[])this.cvimData, (int)20);
        this.getTimespec().tv_nsec(nanoSeconds);
        Date date = new Date(milliSeconds * 1000L);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+9"));
        String collectTime = sdf.format(date);
        if (this.cvimData[22] == 0) {
            return TcsNodeStatus.builder()._id(Long.valueOf(this.nodeId)).nodeId(Long.valueOf(this.nodeId)).isConnect(false).collectTime(collectTime).build();
        }
        if (nodeLength < 18) {
            return null;
        }
        TsiCvimControl tscControlInfo = new TsiCvimControl();
        TsiCvimAbnormal tscAbnormalInfo = new TsiCvimAbnormal();
        ArrayList<TsiCvimStatus> signalStatusInfos = new ArrayList<TsiCvimStatus>();
        byte control = this.cvimData[37];
        tscControlInfo.inManualControl = (control & 1) == 1;
        tscControlInfo.inFlashingControl = (control >> 1 & 1) == 1;
        tscControlInfo.inLightsOutControl = (control >> 2 & 1) == 1;
        tscControlInfo.inActuationControl = (control >> 3 & 1) == 1;
        tscControlInfo.inTransitionControl = (control >> 4 & 1) == 1;
        byte abnormal = this.cvimData[38];
        tscAbnormalInfo.inSignalConflict = (abnormal & 1) == 1;
        tscAbnormalInfo.inCenterComm = (abnormal >> 1 & 1) == 1;
        tscAbnormalInfo.inScuComm = (abnormal >> 2 & 1) == 1;
        int cycleElapsedTime = this.cvimData[39] & 0xFF;
        byte stts = this.cvimData[40];
        int signalStatusInfoCount = stts & 0x7F;
        long localTime = ByteUtils.getUnsignedInt((byte[])this.cvimData, (int)41);
        int ii = 45;
        for (int idx = 0; idx < signalStatusInfoCount; ++idx) {
            TsiCvimStatus status = new TsiCvimStatus();
            int lightsType = this.cvimData[ii] >> 4 & 0xF;
            int lightsStatus = this.cvimData[ii + 1] & 7;
            int reliability = this.cvimData[ii + 1] >> 7 & 1;
            boolean readyPedestrian = (this.cvimData[ii + 1] >> 6 & 1) == 1;
            boolean unProtected = (this.cvimData[ii + 1] >> 3 & 1) == 1;
            int totalSeconds = this.cvimData[ii + 2] & 0xFF;
            int remainSeconds = this.cvimData[ii + 3] & 0xFF;
            int directionCode = this.cvimData[ii + 4] & 0xFF;
            status.setLightsType(eLightsType.getByValue((int)lightsType));
            status.setLightsStatus(eLightsStatus.getByValue((int)lightsStatus));
            status.setTimeReliability(eTimeReliability.getByValue((int)reliability));
            status.setReadyPedestrianSignal(readyPedestrian);
            status.setUnProtectedSignal(unProtected);
            status.setTotalSeconds(totalSeconds);
            status.setRemainingSeconds(remainSeconds);
            status.setDirectionCode(directionCode);
            signalStatusInfos.add(status);
            ii += 5;
        }
        date = new Date(localTime * 1000L);
        sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+9"));
        String tscDateTime = sdf.format(date);
        return TcsNodeStatus.builder()._id(Long.valueOf(this.nodeId)).nodeId(Long.valueOf(this.nodeId)).isConnect(true).collectTime(collectTime).tscDateTime(tscDateTime).cycleElapsedTime(cycleElapsedTime).tscControlInfo(tscControlInfo).tscAbnormalInfo(tscAbnormalInfo).signalStatusInfoCount(signalStatusInfoCount).signalStatusInfos(signalStatusInfos).build();
    }

    public Object getObj() {
        return this.obj;
    }

    public int getLength() {
        return this.length;
    }

    public byte getDataVer() {
        return this.dataVer;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getCvimData() {
        return this.cvimData;
    }

    public byte[] getNodeData() {
        return this.nodeData;
    }

    public List<TsiCpuAddPacket> getAddNodes() {
        return this.addNodes;
    }

    public void setObj(Object obj) {
        this.obj = obj;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public void setDataVer(byte dataVer) {
        this.dataVer = dataVer;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setCvimData(byte[] cvimData) {
        this.cvimData = cvimData;
    }

    public void setNodeData(byte[] nodeData) {
        this.nodeData = nodeData;
    }

    public void setAddNodes(List<TsiCpuAddPacket> addNodes) {
        this.addNodes = addNodes;
    }
}

