/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.repository;

import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsWorker;
import com.tsi.comm.server.process.logging.TsiCvimLoggingProcess;
import com.tsi.comm.server.process.logging.TsiCvimLoggingWorker;
import com.tsi.comm.server.process.packet.TsiChannelSession;
import com.tsi.comm.server.process.packet.TsiCvimPacketProcess;
import com.tsi.comm.server.process.packet.TsiCvimPacketWorker;
import com.tsi.comm.server.repository.TsiNodeManager;
import com.tsi.comm.server.vo.TsiAlarmConfigVo;
import com.tsi.comm.server.vo.TsiNodeVo;
import com.tsi.comm.server.vo.mariadb.AlarmOccrVo;
import com.tsi.comm.server.xnet.NettyUtils;
import com.tsi.common.utils.TimeUtils;
import io.netty.channel.Channel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
public class TsiReportManager {
    private static final Logger log = LoggerFactory.getLogger(TsiReportManager.class);
    private final TsiNodeManager nodeManager;
    private final TsiCvimDbmsProcess dbmsProcess;
    private final TsiCvimLoggingProcess loggingProcess;
    private final TsiCvimPacketProcess packetProcess;
    final String head = "================================================================================================================";

    public void reportNodeSessions() {
        String fileName = "report";
        MDC.put((String)"filename", (String)"report");
        int nodeCount = this.nodeManager.getTsiNodeVoMap().size();
        this.getClass();
        log.info("================================================================================================================");
        log.info("Report Node Sessions: {} Nodes.", (Object)nodeCount);
        int registered = 0;
        int unknown = 0;
        int connected = 0;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+9"));
        log.info("{}", (Object)String.format("%10s %4s %7s %19s %19s %9s %6s %19s  Remote-Address", "ID", "INTC", "Connect", "Connect Time", "Disconnect Time", "Connected", "Closed", "Last-Recv-Time"));
        log.info("----------------------------------------------------------------------------------------------------------------");
        for (Map.Entry obj : this.nodeManager.getTsiNodeVoMap().entrySet()) {
            String info;
            String connect;
            TsiNodeVo node = (TsiNodeVo)obj.getValue();
            String check = node.isInstalled() ? "Y" : "N";
            check = check + (node.isSendNode() ? "Y" : "N");
            check = check + (node.isSendTest() ? "Y" : "N");
            check = check + (node.isSendCvim() ? "Y" : "N");
            if (node.isRegistered()) {
                ++registered;
            } else {
                ++unknown;
            }
            if (node.isConnect()) {
                ++connected;
                connect = "Y";
                info = NettyUtils.getRemoteAddress((Channel)node.getChannel());
            } else {
                connect = "N";
                info = "---";
            }
            String connectTm = sdf.format(new Date(node.getConnectTm()));
            String disconnectTm = sdf.format(new Date(node.getDisconnectTm()));
            String lastCommTm = sdf.format(new Date(node.getLastCommTm()));
            log.info("{}", (Object)String.format("%10s %4s %7s %19s %19s %9d %6d %19s  %s", node.getKey(), check, connect, connectTm, disconnectTm, node.getConnectCount().get(), node.getDisconnectCount().get(), lastCommTm, info));
        }
        log.info("----------------------------------------------------------------------------------------------------------------");
        log.info("Total Nodes: {} EA, Registered: {} EA, Unknown: {} EA, Connected: {} EA", new Object[]{nodeCount, registered, unknown, connected});
        log.info("==============================================");
        MDC.clear();
    }

    public void checkSessionTimeout(long timeout) {
        String fileName = "timeout";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+9"));
        long currTm = System.currentTimeMillis();
        for (Map.Entry obj : this.nodeManager.getTsiNodeVoMap().entrySet()) {
            TsiNodeVo node = (TsiNodeVo)obj.getValue();
            if (!node.isConnect() || currTm - node.getLastCommTm() <= timeout) continue;
            try {
                String ipAddress = node.getIpAddr();
                if (node.getChannel() != null) {
                    ipAddress = NettyUtils.getRemoteIpAddress((Channel)node.getChannel());
                }
                AlarmOccrVo alarm = new AlarmOccrVo(4);
                alarm.setAlarmCode(TsiAlarmConfigVo.COMM_02);
                alarm.setAlarmTarget(node.getKey());
                alarm.setAlarmValue(ipAddress);
                this.dbmsProcess.add((Object)alarm, node.getDbmsQIdx());
                String connectTm = sdf.format(new Date(node.getConnectTm()));
                String lastCommTm = sdf.format(new Date(node.getLastCommTm()));
                MDC.put((String)"filename", (String)"timeout");
                log.info("Node: {}, Recv Timeout: Connect: {}, LastCommTime: {}, timeout: {}", new Object[]{node.getKey(), connectTm, lastCommTm, timeout});
                MDC.clear();
                TsiChannelSession.sessionTimeout((TsiNodeVo)node, (String)NettyUtils.getRemoteIpAddress((Channel)node.getChannel()));
                if (node.getChannel() == null) continue;
                node.getChannel().close();
            }
            catch (Exception e) {
                log.error("checkSessionTimeout: {}", (Object)e.getMessage());
            }
        }
    }

    public void reportQueueInfo(boolean isAlert) {
        String fileName = "queue";
        MDC.put((String)"filename", (String)"queue");
        boolean isTail = false;
        int remainingCapacity = 0;
        if (isAlert) {
            this.getClass();
            log.info("================================================================================================================");
            log.info("Worker Queue Information.");
        }
        List processWorkerList = this.packetProcess.getWorkerList();
        int n = remainingCapacity = isAlert ? this.packetProcess.getQSize() : 100;
        if (isAlert) {
            log.info("-----  Packet Worker: {} EA, QSize: {} EA.", (Object)processWorkerList.size(), (Object)this.packetProcess.getQSize());
        }
        List packetWorkers = processWorkerList.stream().filter(worker -> worker instanceof TsiCvimPacketWorker).map(worker -> (TsiCvimPacketWorker)worker).collect(Collectors.toList());
        for (TsiCvimPacketWorker worker2 : packetWorkers) {
            if (worker2.getDATA_QUEUE().remainingCapacity() > remainingCapacity) continue;
            log.info("PacketWorker({}), Total/Size/Remain: {}/{}/{}, Average: {}", new Object[]{worker2.getIdx(), worker2.getQSize(), worker2.getDATA_QUEUE().size(), worker2.getDATA_QUEUE().remainingCapacity(), TimeUtils.elapsedTimeStr((long)worker2.getAvgTime())});
            isTail = true;
        }
        List dbmsWorkerList = this.dbmsProcess.getWorkerList();
        int n2 = remainingCapacity = isAlert ? this.dbmsProcess.getQSize() : 100;
        if (isAlert) {
            log.info("-----    Dbms Worker: {} EA, QSize: {} EA.", (Object)dbmsWorkerList.size(), (Object)this.dbmsProcess.getQSize());
        }
        List dbmsWorkers = dbmsWorkerList.stream().filter(worker -> worker instanceof TsiCvimDbmsWorker).map(worker -> (TsiCvimDbmsWorker)worker).collect(Collectors.toList());
        for (TsiCvimDbmsWorker worker3 : dbmsWorkers) {
            if (worker3.getDATA_QUEUE().remainingCapacity() > remainingCapacity) continue;
            log.info("DbmsWorker({}), Total/Size/Remain: {}/{}/{}, Average: {}", new Object[]{worker3.getIdx(), worker3.getQSize(), worker3.getDATA_QUEUE().size(), worker3.getDATA_QUEUE().remainingCapacity(), TimeUtils.elapsedTimeStr((long)worker3.getAvgTime())});
            isTail = true;
        }
        if (this.loggingProcess.isEnabled()) {
            List loggingWorkerList = this.loggingProcess.getWorkerList();
            int n3 = remainingCapacity = isAlert ? this.loggingProcess.getQSize() : 100;
            if (isAlert) {
                log.info("----- Logging Worker: {} EA, QSize: {} EA.", (Object)loggingWorkerList.size(), (Object)this.loggingProcess.getQSize());
            }
            List loggingWorkers = loggingWorkerList.stream().filter(worker -> worker instanceof TsiCvimLoggingWorker).map(worker -> (TsiCvimLoggingWorker)worker).collect(Collectors.toList());
            for (TsiCvimLoggingWorker worker4 : loggingWorkers) {
                if (worker4.getDATA_QUEUE().remainingCapacity() > remainingCapacity) continue;
                log.info("LoggingWorker({}), Total/Size/Remain: {}/{}/{}, Average: {}", new Object[]{worker4.getIdx(), worker4.getQSize(), worker4.getDATA_QUEUE().size(), worker4.getDATA_QUEUE().remainingCapacity(), TimeUtils.elapsedTimeStr((long)worker4.getAvgTime())});
                isTail = true;
            }
        } else if (isAlert) {
            log.info(" Logging Worker is disabled (useLoggingThread=false).");
        }
        if (isTail) {
            this.getClass();
            log.info("================================================================================================================");
        }
        MDC.clear();
    }

    public TsiReportManager(TsiNodeManager nodeManager, TsiCvimDbmsProcess dbmsProcess, TsiCvimLoggingProcess loggingProcess, TsiCvimPacketProcess packetProcess) {
        this.nodeManager = nodeManager;
        this.dbmsProcess = dbmsProcess;
        this.loggingProcess = loggingProcess;
        this.packetProcess = packetProcess;
    }
}

