/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.repository;

import com.tsi.comm.server.vo.TsiNodeVo;
import com.tsi.comm.server.xnet.NettyUtils;
import com.tsi.common.utils.Counter;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TsiSessionManager {
    private static final Logger log = LoggerFactory.getLogger(TsiSessionManager.class);
    public static final AttributeKey<TsiNodeVo> TSI_NODE_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"TsiNode");
    public static final AttributeKey<Integer> PKT_Q_IDX_KEY = AttributeKey.valueOf((String)"pktQIdx");
    public static final AttributeKey<Integer> DBMS_Q_IDX_KEY = AttributeKey.valueOf((String)"dbmsQIdx");
    public static final AttributeKey<Integer> LOG_Q_IDX_KEY = AttributeKey.valueOf((String)"logQIdx");
    public static final String MDC_LOGGING_HANDLER_NAME = "dumpLogger";
    public static final AttributeKey<Boolean> UNAUTHENTICATED_KEY = AttributeKey.valueOf((String)"unauthenticated");
    private final Counter sessions = new Counter();
    private final ConcurrentHashMap<Channel, TsiNodeVo> channelNodeMap = new ConcurrentHashMap();

    public int add() {
        return (int)this.sessions.increment();
    }

    public int remove() {
        return (int)this.sessions.decrement();
    }

    public int getCount() {
        return (int)this.sessions.get();
    }

    public int getChannelCount() {
        return this.channelNodeMap.size();
    }

    public void addChannel(Channel channel, TsiNodeVo vo) {
        if (channel == null) {
            return;
        }
        this.channelNodeMap.put(channel, vo);
    }

    public void removeChannel(Channel channel) {
        if (channel == null) {
            return;
        }
        this.channelNodeMap.remove(channel);
    }

    public TsiNodeVo getNodeVo(Channel channel) {
        if (channel == null) {
            return null;
        }
        return (TsiNodeVo)this.channelNodeMap.get(channel);
    }

    public void reportChannelSessions() {
        log.info("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
        log.info("Report Channel Sessions: {} Sessions.", (Object)this.sessions.get());
        log.info("{}", (Object)String.format("%10s %7s  Remote-Address", "ID", "Active"));
        log.info("----------------------------------------------------------------------------------------------------------------");
        for (Map.Entry obj : this.channelNodeMap.entrySet()) {
            Channel channel = (Channel)obj.getKey();
            TsiNodeVo node = (TsiNodeVo)obj.getValue();
            log.info("{}", (Object)String.format("%10s %7s  %s", node.getNodeId(), channel.isActive(), NettyUtils.getRemoteAddress((Channel)channel)));
        }
        log.info("++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++");
    }

    public ConcurrentHashMap<Channel, TsiNodeVo> getChannelNodeMap() {
        return this.channelNodeMap;
    }
}

