/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.service;

import com.tsi.comm.server.dao.maraidb.mapper.TsiCommServerMapper;
import com.tsi.comm.server.repository.ApplicationRepository;
import com.tsi.comm.server.repository.TsiAlarmManager;
import com.tsi.comm.server.repository.TsiNodeAddManager;
import com.tsi.comm.server.repository.TsiNodeManager;
import com.tsi.comm.server.service.TsiQueueDistributorService;
import com.tsi.comm.server.vo.TsiAlarmConfigVo;
import com.tsi.comm.server.vo.TsiNodeAddDetailVo;
import com.tsi.comm.server.vo.TsiNodeAddVo;
import com.tsi.comm.server.vo.TsiNodeVo;
import com.tsi.comm.server.vo.mariadb.AlarmConfigVo;
import com.tsi.comm.server.vo.mariadb.AlarmOccrVo;
import com.tsi.comm.server.vo.mariadb.NodeAddDetailVo;
import com.tsi.comm.server.vo.mariadb.NodeAddVo;
import com.tsi.comm.server.vo.mariadb.NodeVo;
import com.tsi.common.utils.TimeUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TsiCommServerService {
    private static final Logger log = LoggerFactory.getLogger(TsiCommServerService.class);
    private final TsiCommServerMapper databaseMapper;
    private final TsiNodeManager nodeManager;
    private final TsiAlarmManager alarmManager;
    private final TsiNodeAddManager nodeAddManager;
    private final TsiQueueDistributorService queueDistributorService;

    public void init() {
        this.initDatabase();
        this.loadDatabase();
    }

    public void loadAlarmConfig() {
        long startTime = System.nanoTime();
        List objLists = this.databaseMapper.getAlarmConfig();
        for (AlarmConfigVo obj : objLists) {
            TsiAlarmConfigVo alarm = this.alarmManager.get(obj.getAlarmCode());
            if (alarm != null) {
                alarm.setDesc(obj.getDesc());
                alarm.setValue(obj.getValue());
                alarm.setUseYn(obj.getUseYn().equals("Y"));
                continue;
            }
            alarm = new TsiAlarmConfigVo();
            alarm.setAlarmCode(obj.getAlarmCode());
            alarm.setDesc(obj.getDesc());
            alarm.setValue(obj.getValue());
            alarm.setUseYn(obj.getUseYn().equals("Y"));
            this.alarmManager.put(obj.getAlarmCode(), alarm);
        }
        log.info("loadAlarmConfig: ..end. {}/{} EA. {}", new Object[]{objLists.size(), this.alarmManager.size(), TimeUtils.elapsedTime((long)startTime)});
    }

    public void initDatabase() {
    }

    public void loadDatabase() {
        this.loadTsiNode();
        this.loadTsiNodeAdd();
        this.loadAlarmConfig();
    }

    private void loadTsiNode() {
        long startTime = System.nanoTime();
        this.nodeManager.beforeLoading();
        boolean idx = false;
        List objLists = this.databaseMapper.getNodeInfoList();
        for (NodeVo obj : objLists) {
            String ipAddr;
            boolean installed = "Y".equals(obj.getUseYn());
            TsiNodeVo nodeVo = this.nodeManager.get(obj.getNodeId().longValue());
            if (nodeVo != null) {
                nodeVo.setCheckInstalled(installed);
                nodeVo.setSendTest("Y".equals(obj.getTestYn()));
                nodeVo.setSendNode("Y".equals(obj.getNodeYn()));
                nodeVo.setSendCvim("Y".equals(obj.getCvimYn()));
                nodeVo.setRegistered(true);
            } else {
                nodeVo = new TsiNodeVo(obj.getNodeId().longValue(), obj.getIpAddr(), obj.getTestYn().equals("Y"), obj.getNodeYn().equals("Y"), obj.getCvimYn().equals("Y"));
                nodeVo.setRegistered(true);
                nodeVo.setCheckInstalled(installed);
                nodeVo.setPktQIdx(0);
                nodeVo.setDbmsQIdx(0);
                nodeVo.setLogQIdx(0);
                this.nodeManager.put(obj.getNodeId().longValue(), nodeVo);
            }
            if ("0.0.0.0".equals(ipAddr = obj.getIpAddr())) continue;
            this.nodeManager.putIpAddr(ipAddr, nodeVo);
        }
        this.nodeManager.afterLoading();
        log.info("loadTsiNode: ..end. {}/{} EA. {}", new Object[]{objLists.size(), this.nodeManager.size(), TimeUtils.elapsedTime((long)startTime)});
    }

    private void loadTsiNodeAdd() {
        long startTime = System.nanoTime();
        List objLists = this.databaseMapper.getNodeAddInfoList();
        for (NodeAddVo obj : objLists) {
            long originNodeId = obj.getOriginNodeId();
            TsiNodeVo orgTsiNodeVo = this.nodeManager.get(originNodeId);
            if (orgTsiNodeVo == null) {
                log.error("Not found origin_node_id: {}", (Object)originNodeId);
                String ipAddr = "0.0.0.0";
                orgTsiNodeVo = new TsiNodeVo(originNodeId, ipAddr, true, true, true);
                orgTsiNodeVo.setCheckInstalled(true);
                orgTsiNodeVo.setRegistered(false);
                orgTsiNodeVo.setAddNodeEnabled(true);
                this.nodeManager.put(originNodeId, orgTsiNodeVo);
            } else {
                orgTsiNodeVo.setAddNodeEnabled(true);
            }
            TsiNodeAddVo tsiNodeAddVo = new TsiNodeAddVo();
            tsiNodeAddVo.setOriginNodeId(originNodeId);
            for (int ii = 0; ii < obj.getAddDetailList().size(); ++ii) {
                NodeAddDetailVo nodeAddDetailVo = (NodeAddDetailVo)obj.getAddDetailList().get(ii);
                Long nodeId = nodeAddDetailVo.getNodeId();
                TsiNodeAddDetailVo tsiNodeAddDetailVo = new TsiNodeAddDetailVo();
                TsiNodeVo addNodeVo = this.nodeManager.get(nodeId.longValue());
                if (addNodeVo == null) {
                    log.error("Not found add_node_id: {}", (Object)nodeId);
                    addNodeVo = new TsiNodeVo(originNodeId, orgTsiNodeVo.getIpAddr(), orgTsiNodeVo.isSendTest(), orgTsiNodeVo.isSendNode(), orgTsiNodeVo.isSendCvim());
                    addNodeVo.setCheckInstalled(true);
                    addNodeVo.setRegistered(false);
                    this.nodeManager.put(nodeId.longValue(), addNodeVo);
                }
                tsiNodeAddDetailVo.setNodeId(nodeId.longValue());
                tsiNodeAddDetailVo.setOriginDirCode(nodeAddDetailVo.getOriginDirCode());
                tsiNodeAddDetailVo.setAddNodeOrder(nodeAddDetailVo.getAddNodeOrder());
                tsiNodeAddDetailVo.setAddDirCode(nodeAddDetailVo.getAddDirCode());
                tsiNodeAddDetailVo.setNodeObj(addNodeVo);
                tsiNodeAddVo.getAddNodeMap().put(tsiNodeAddDetailVo.getOriginDirCode() * 1000 + tsiNodeAddDetailVo.getAddNodeOrder(), tsiNodeAddDetailVo);
            }
            orgTsiNodeVo.setTsiNodeAddVo(tsiNodeAddVo);
            this.nodeAddManager.put(tsiNodeAddVo.getOriginNodeId(), tsiNodeAddVo);
        }
        log.info("loadTsiNodeAdd: ..end. {} EA. {}", (Object)this.nodeAddManager.size(), (Object)TimeUtils.elapsedTime((long)startTime));
    }

    public void updateNodeStatusTerm(int serverId) {
        int result = this.databaseMapper.updateNodeStatusTerm(Integer.valueOf(serverId));
        log.info("update node status term: {} EA", (Object)result);
    }

    public int insertAlarmOccrHs(AlarmOccrVo vo) {
        int res = 0;
        try {
            res = this.databaseMapper.insertAlarmOccrHs(vo);
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage());
        }
        return res;
    }

    public int updateProcessState(int flag) {
        int res = 0;
        try {
            res = flag == 0 ? this.databaseMapper.updateProcessStatusStart(ApplicationRepository.processStateVo) : (flag == 1 ? this.databaseMapper.updateProcessStatusRun(ApplicationRepository.processStateVo) : this.databaseMapper.updateProcessStatusStop(ApplicationRepository.processStateVo));
        }
        catch (Exception e) {
            log.error("{}", (Object)e.getMessage());
        }
        return res;
    }

    public TsiCommServerMapper getDatabaseMapper() {
        return this.databaseMapper;
    }

    public TsiNodeManager getNodeManager() {
        return this.nodeManager;
    }

    public TsiAlarmManager getAlarmManager() {
        return this.alarmManager;
    }

    public TsiNodeAddManager getNodeAddManager() {
        return this.nodeAddManager;
    }

    public TsiQueueDistributorService getQueueDistributorService() {
        return this.queueDistributorService;
    }

    public TsiCommServerService(TsiCommServerMapper databaseMapper, TsiNodeManager nodeManager, TsiAlarmManager alarmManager, TsiNodeAddManager nodeAddManager, TsiQueueDistributorService queueDistributorService) {
        this.databaseMapper = databaseMapper;
        this.nodeManager = nodeManager;
        this.alarmManager = alarmManager;
        this.nodeAddManager = nodeAddManager;
        this.queueDistributorService = queueDistributorService;
    }
}

