/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.tcp;

import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.tcp.initializer.CvimServerInitializer;
import com.tsi.comm.server.xnet.NettyServerConfig;
import com.tsi.comm.server.xnet.NettyTcpServer;
import com.tsi.comm.server.xnet.NettyUtils;
import com.tsi.common.utils.OS;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.epoll.Epoll;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class TsiCvimServer
extends NettyTcpServer {
    private static final Logger log = LoggerFactory.getLogger(TsiCvimServer.class);
    private final TsiCvimServerConfig config;

    public TsiCvimServer(TsiCvimServerConfig config) {
        super((NettyServerConfig)config);
        this.config = config;
    }

    @PostConstruct
    public void initialize() {
        super.setChannelInitializer((ChannelInitializer)new CvimServerInitializer(this.config));
        if (!OS.isWindows() && !Epoll.isAvailable()) {
            log.warn("TsiCvimServer Epoll not support: {}", (Object)Epoll.unavailabilityCause().toString());
        }
        if (NettyUtils.isEpollAvailable()) {
            log.info("Server is running in Linux EPOLL mode.");
        } else {
            log.info("Server is running in Windows NIO mode.");
        }
    }
}

