/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.tcp.codec;

import com.tsi.comm.server.protocol.TsiCpuPacket;
import com.tsi.comm.server.xnet.NettyUtils;
import com.tsi.common.utils.TimeUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class CvimServerByteBufMessageDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final Logger log = LoggerFactory.getLogger(CvimServerByteBufMessageDecoder.class);

    protected void decode(ChannelHandlerContext ctx, ByteBuf byteBuf, List<Object> out) {
        long msec = TimeUtils.currentTimeSeconds();
        long nsec = System.nanoTime();
        if (byteBuf == null) {
            log.error("Receive: Packet frame packet error. length field data error");
            ctx.close();
            return;
        }
        int readableBytes = byteBuf.readableBytes();
        if (readableBytes < 10) {
            log.error("Receive: Packet readableBytes too small: {}, required min size: {}", (Object)readableBytes, (Object)10);
            ctx.close();
            return;
        }
        long nodeId = byteBuf.getUnsignedInt(6);
        long remoteIpAddress = NettyUtils.getRemoteIpAddressToLong((Channel)ctx.channel());
        int remotePort = NettyUtils.getRemotePort((Channel)ctx.channel());
        TsiCpuPacket packet = new TsiCpuPacket(nodeId, msec, nsec, remoteIpAddress, remotePort);
        packet.setBuf(new byte[readableBytes]);
        byteBuf.readBytes(packet.getBuf());
        packet.setObj(null);
        out.add(packet);
    }
}

