/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.tcp.handler;

import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.process.dbms.TsiCvimDbmsProcess;
import com.tsi.comm.server.process.packet.TsiChannelSession;
import com.tsi.comm.server.process.packet.TsiCvimPacketProcess;
import com.tsi.comm.server.protocol.TsiCpuPacket;
import com.tsi.comm.server.repository.TsiAlarmManager;
import com.tsi.comm.server.repository.TsiNodeManager;
import com.tsi.comm.server.repository.TsiSessionManager;
import com.tsi.comm.server.repository.TsiTpmsManager;
import com.tsi.comm.server.service.TsiQueueDistributorService;
import com.tsi.comm.server.vo.TsiAlarmConfigVo;
import com.tsi.comm.server.vo.TsiNodeVo;
import com.tsi.comm.server.vo.mariadb.AlarmOccrVo;
import com.tsi.comm.server.vo.mariadb.NodeIpAddrVo;
import com.tsi.comm.server.vo.mariadb.NodeStatusVo;
import com.tsi.comm.server.xnet.NettyUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.CorruptedFrameException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ChannelHandler.Sharable
public class CvimServerPacketProcessHandler
extends SimpleChannelInboundHandler<TsiCpuPacket> {
    private static final Logger log = LoggerFactory.getLogger(CvimServerPacketProcessHandler.class);
    private final TsiCvimServerConfig config;
    private final TsiNodeManager nodeManager;
    private final TsiAlarmManager alarmManager;
    private final TsiTpmsManager tpmsManager;
    private final TsiSessionManager sessionManager;
    private final TsiCvimPacketProcess packetProcess;
    private final TsiCvimDbmsProcess dbmsProcess;
    private final TsiQueueDistributorService queueDistributorService;

    protected void channelRead0(ChannelHandlerContext ctx, TsiCpuPacket packet) throws Exception {
        String remoteIpAddress = NettyUtils.getRemoteIpAddress((Channel)ctx.channel());
        long nodeId = packet.getNodeId();
        TsiNodeVo nodeVo = (TsiNodeVo)ctx.channel().attr(TsiSessionManager.TSI_NODE_ATTRIBUTE_KEY).get();
        if (nodeVo == null) {
            nodeVo = this.attachNodeVo(nodeId, remoteIpAddress, ctx.channel());
            if (nodeVo == null) {
                if (nodeId <= 0L) {
                    byte[] buf = packet.getBuf();
                    this.alarmManager.loggingUnknownNodePacket(nodeId, ctx.channel(), buf);
                }
                ctx.close();
                return;
            }
            Channel oldChannel = nodeVo.connectChannel(ctx.channel(), this.alarmManager, remoteIpAddress);
            this.sessionManager.addChannel(ctx.channel(), nodeVo);
            TsiChannelSession.objectRegistered((TsiNodeVo)nodeVo, (String)remoteIpAddress);
            this.queueDistributorService.setLoadedQueue(nodeVo);
            ctx.channel().attr(TsiSessionManager.PKT_Q_IDX_KEY).set((Object)nodeVo.getPktQIdx());
            ctx.channel().attr(TsiSessionManager.DBMS_Q_IDX_KEY).set((Object)nodeVo.getDbmsQIdx());
            ctx.channel().attr(TsiSessionManager.LOG_Q_IDX_KEY).set((Object)nodeVo.getLogQIdx());
            ctx.channel().attr(TsiSessionManager.TSI_NODE_ATTRIBUTE_KEY).set((Object)nodeVo);
            if (!remoteIpAddress.equals(nodeVo.getIpAddr())) {
                String oldIpAddr = nodeVo.getIpAddr();
                log.warn("Node IpAddr Changed: {} -> {}", (Object)oldIpAddr, (Object)remoteIpAddress);
                nodeVo.setIpAddr(remoteIpAddress);
                NodeIpAddrVo nodeIpAddrVo = new NodeIpAddrVo(6);
                nodeIpAddrVo.setNodeId(nodeVo.getNodeId());
                nodeIpAddrVo.setIpAddr(remoteIpAddress);
                this.nodeManager.putIpAddr(remoteIpAddress, nodeVo);
                this.dbmsProcess.add((Object)nodeIpAddrVo, nodeVo.getDbmsQIdx());
            }
            if (nodeVo.isRegistered()) {
                NodeStatusVo status = new NodeStatusVo(1);
                status.setServerId(this.config.getServerId());
                status.setNodeId(nodeId);
                status.setStatus(1);
                status.setIpAddr(NettyUtils.getRemoteIpAddress((Channel)ctx.channel()));
                this.dbmsProcess.add((Object)status, nodeVo.getDbmsQIdx());
            }
        }
        long DUPLICATE_PACKET_INTERVAL_MS = 600L;
        if (!nodeVo.isProcessable(600L)) {
            return;
        }
        nodeVo.packetProcessingStarted();
        packet.setObj((Object)nodeVo);
        nodeVo.setLastCommTm(System.currentTimeMillis());
        this.packetProcess.add((Object)packet, nodeVo.getPktQIdx());
        packet.setAdd(System.nanoTime());
        this.tpmsManager.readPacket(packet);
        if (nodeVo.isDump()) {
            TsiChannelSession.recvPacketDump((TsiNodeVo)nodeVo, (TsiCpuPacket)packet);
        }
    }

    private TsiNodeVo attachNodeVo(long nodeId, String remoteIpAddress, Channel channel) {
        return this.nodeManager.getOrCompute(nodeId, id -> {
            this.alarmManager.loggingUnknownNode(id.longValue(), channel);
            if (id <= 0L) {
                return null;
            }
            log.info("Creating new TsiNodeVo for unregistered node ID: {}", id);
            TsiNodeVo newNodeVo = new TsiNodeVo(id.longValue(), remoteIpAddress, false, true, true);
            newNodeVo.setCheckInstalled(true);
            newNodeVo.setRegistered(false);
            this.nodeManager.putIpAddr(remoteIpAddress, newNodeVo);
            if (this.alarmManager.checkAlarm(TsiAlarmConfigVo.COMM_01)) {
                AlarmOccrVo alarm = new AlarmOccrVo(4);
                alarm.setAlarmCode(TsiAlarmConfigVo.COMM_01);
                alarm.setAlarmTarget(Long.toString(id));
                alarm.setAlarmValue(remoteIpAddress);
                this.dbmsProcess.add((Object)alarm, 0);
            }
            return newNodeVo;
        });
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        TsiNodeVo nodeVo = (TsiNodeVo)ctx.channel().attr(TsiSessionManager.TSI_NODE_ATTRIBUTE_KEY).get();
        if (cause instanceof CorruptedFrameException) {
            log.warn("Exception CorruptedFrameException {}: {}", (Object)NettyUtils.getAddress((Channel)ctx.channel()), (Object)cause.getMessage());
        } else if (nodeVo != null) {
            log.error("Exception processing packet, Node ID {}:", (Object)nodeVo.getNodeId(), (Object)cause);
        } else {
            log.error("Exception in pipeline for channel {}:", (Object)NettyUtils.getAddress((Channel)ctx.channel()), (Object)cause);
        }
        ctx.close();
    }

    public CvimServerPacketProcessHandler(TsiCvimServerConfig config, TsiNodeManager nodeManager, TsiAlarmManager alarmManager, TsiTpmsManager tpmsManager, TsiSessionManager sessionManager, TsiCvimPacketProcess packetProcess, TsiCvimDbmsProcess dbmsProcess, TsiQueueDistributorService queueDistributorService) {
        this.config = config;
        this.nodeManager = nodeManager;
        this.alarmManager = alarmManager;
        this.tpmsManager = tpmsManager;
        this.sessionManager = sessionManager;
        this.packetProcess = packetProcess;
        this.dbmsProcess = dbmsProcess;
        this.queueDistributorService = queueDistributorService;
    }
}

