/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.tcp.initializer;

import com.tsi.comm.server.config.TsiCvimServerConfig;
import com.tsi.comm.server.process.packet.TsiChannelSession;
import com.tsi.comm.server.repository.TsiAlarmManager;
import com.tsi.comm.server.repository.TsiNodeManager;
import com.tsi.comm.server.tcp.codec.CvimServerByteBufMessageDecoder;
import com.tsi.comm.server.tcp.codec.CvimServerEncoder;
import com.tsi.comm.server.tcp.handler.CvimServerInboundMessageHandler;
import com.tsi.comm.server.tcp.handler.CvimServerPacketProcessHandler;
import com.tsi.comm.server.tcp.handler.MdcLoggingHandler;
import com.tsi.comm.server.vo.TsiAlarmConfigVo;
import com.tsi.comm.server.vo.TsiNodeVo;
import com.tsi.comm.server.xnet.NettyUtils;
import com.tsi.common.spring.SpringUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.timeout.IdleStateHandler;

public class CvimServerInitializer
extends ChannelInitializer<Channel> {
    private final TsiCvimServerConfig config;
    private final CvimServerByteBufMessageDecoder cvimServerByteBufMessageDecoder;
    private final CvimServerPacketProcessHandler cvimServerPacketProcessHandler;
    private final CvimServerInboundMessageHandler cvimServerInboundMessageHandler;
    private final CvimServerEncoder cvimServerEncoder;
    private final TsiNodeManager nodeManager;
    private int readerIdleTimeSeconds;

    public CvimServerInitializer(TsiCvimServerConfig config) {
        this.config = config;
        this.cvimServerByteBufMessageDecoder = (CvimServerByteBufMessageDecoder)SpringUtils.getBean(CvimServerByteBufMessageDecoder.class);
        this.cvimServerPacketProcessHandler = (CvimServerPacketProcessHandler)SpringUtils.getBean(CvimServerPacketProcessHandler.class);
        this.cvimServerInboundMessageHandler = (CvimServerInboundMessageHandler)SpringUtils.getBean(CvimServerInboundMessageHandler.class);
        this.cvimServerEncoder = (CvimServerEncoder)SpringUtils.getBean(CvimServerEncoder.class);
        this.nodeManager = (TsiNodeManager)SpringUtils.getBean(TsiNodeManager.class);
        TsiAlarmManager alarmManager = (TsiAlarmManager)SpringUtils.getBean(TsiAlarmManager.class);
        this.readerIdleTimeSeconds = config.getReaderIdleTimeSeconds();
        TsiAlarmConfigVo vo = alarmManager.get(TsiAlarmConfigVo.COMM_02);
        if (vo != null) {
            this.readerIdleTimeSeconds = vo.getValue();
        }
        if (this.readerIdleTimeSeconds < 5) {
            this.readerIdleTimeSeconds = 5;
        }
    }

    protected void initChannel(Channel channel) throws Exception {
        String remoteIpAddress = NettyUtils.getRemoteIpAddress((Channel)channel);
        if (this.config.isInWhitelistIps(remoteIpAddress)) {
            channel.close();
            return;
        }
        TsiNodeVo nodeVo = this.nodeManager.getIpAddr(remoteIpAddress);
        IdleStateHandler idleStateHandler = new IdleStateHandler(this.readerIdleTimeSeconds, 0, 0);
        ChannelPipeline pipeline = channel.pipeline();
        if (nodeVo != null && nodeVo.isTcpDump()) {
            pipeline.addLast("dumpLogger", (ChannelHandler)new MdcLoggingHandler(LogLevel.INFO));
        }
        pipeline.addLast("idleStateHandler", (ChannelHandler)idleStateHandler);
        pipeline.addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(2048, 2, 2, -2, 0));
        pipeline.addLast("packetDecoder", (ChannelHandler)this.cvimServerByteBufMessageDecoder);
        pipeline.addLast("packetProcessor", (ChannelHandler)this.cvimServerPacketProcessHandler);
        pipeline.addLast("packetInboundHandler", (ChannelHandler)this.cvimServerInboundMessageHandler);
        pipeline.addLast("frameEncoder", (ChannelHandler)this.cvimServerEncoder);
        TsiChannelSession.initChannel((TsiNodeVo)nodeVo, (String)remoteIpAddress);
    }
}

