/*
 * Decompiled with CFR 0.152.
 */
package com.tsi.comm.server.xnet;

public abstract class NettyServerConfig {
    protected String bindingAddr = "";
    protected int bindingPort = 9091;
    protected int backlog = 0;
    protected int acceptThreads = 0;
    protected int workerThreads = 0;
    protected int rcvBuf = 0;
    protected int sndBuf = 0;
    protected int readerIdleTimeSeconds = 0;
    protected int writerIdleTimeSeconds = 0;
    protected int allIdleTimeSeconds = 0;
    protected int connectTimeoutSeconds = 0;

    protected void configure() {
        int NETTY_DEFAULT_EVENT_THREADS = Runtime.getRuntime().availableProcessors() * 2;
        if (this.bindingAddr.isEmpty()) {
            this.bindingAddr = "0.0.0.0";
        }
        if (this.backlog == 0) {
            this.backlog = 1024;
        }
        if (this.acceptThreads == 0) {
            this.acceptThreads = 2;
        }
        if (this.workerThreads == 0) {
            this.workerThreads = NETTY_DEFAULT_EVENT_THREADS;
        }
        if (this.rcvBuf == 0) {
            this.rcvBuf = 16383;
        }
        if (this.sndBuf == 0) {
            this.sndBuf = 16383;
        }
        if (this.readerIdleTimeSeconds < 5) {
            this.readerIdleTimeSeconds = 5;
        }
    }

    public String getBindingAddr() {
        return this.bindingAddr;
    }

    public int getBindingPort() {
        return this.bindingPort;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public int getAcceptThreads() {
        return this.acceptThreads;
    }

    public int getWorkerThreads() {
        return this.workerThreads;
    }

    public int getRcvBuf() {
        return this.rcvBuf;
    }

    public int getSndBuf() {
        return this.sndBuf;
    }

    public int getReaderIdleTimeSeconds() {
        return this.readerIdleTimeSeconds;
    }

    public int getWriterIdleTimeSeconds() {
        return this.writerIdleTimeSeconds;
    }

    public int getAllIdleTimeSeconds() {
        return this.allIdleTimeSeconds;
    }

    public int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public void setBindingAddr(String bindingAddr) {
        this.bindingAddr = bindingAddr;
    }

    public void setBindingPort(int bindingPort) {
        this.bindingPort = bindingPort;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public void setAcceptThreads(int acceptThreads) {
        this.acceptThreads = acceptThreads;
    }

    public void setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    public void setRcvBuf(int rcvBuf) {
        this.rcvBuf = rcvBuf;
    }

    public void setSndBuf(int sndBuf) {
        this.sndBuf = sndBuf;
    }

    public void setReaderIdleTimeSeconds(int readerIdleTimeSeconds) {
        this.readerIdleTimeSeconds = readerIdleTimeSeconds;
    }

    public void setWriterIdleTimeSeconds(int writerIdleTimeSeconds) {
        this.writerIdleTimeSeconds = writerIdleTimeSeconds;
    }

    public void setAllIdleTimeSeconds(int allIdleTimeSeconds) {
        this.allIdleTimeSeconds = allIdleTimeSeconds;
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NettyServerConfig)) {
            return false;
        }
        NettyServerConfig other = (NettyServerConfig)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getBindingPort() != other.getBindingPort()) {
            return false;
        }
        if (this.getBacklog() != other.getBacklog()) {
            return false;
        }
        if (this.getAcceptThreads() != other.getAcceptThreads()) {
            return false;
        }
        if (this.getWorkerThreads() != other.getWorkerThreads()) {
            return false;
        }
        if (this.getRcvBuf() != other.getRcvBuf()) {
            return false;
        }
        if (this.getSndBuf() != other.getSndBuf()) {
            return false;
        }
        if (this.getReaderIdleTimeSeconds() != other.getReaderIdleTimeSeconds()) {
            return false;
        }
        if (this.getWriterIdleTimeSeconds() != other.getWriterIdleTimeSeconds()) {
            return false;
        }
        if (this.getAllIdleTimeSeconds() != other.getAllIdleTimeSeconds()) {
            return false;
        }
        if (this.getConnectTimeoutSeconds() != other.getConnectTimeoutSeconds()) {
            return false;
        }
        String this$bindingAddr = this.getBindingAddr();
        String other$bindingAddr = other.getBindingAddr();
        return !(this$bindingAddr == null ? other$bindingAddr != null : !this$bindingAddr.equals(other$bindingAddr));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NettyServerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getBindingPort();
        result = result * 59 + this.getBacklog();
        result = result * 59 + this.getAcceptThreads();
        result = result * 59 + this.getWorkerThreads();
        result = result * 59 + this.getRcvBuf();
        result = result * 59 + this.getSndBuf();
        result = result * 59 + this.getReaderIdleTimeSeconds();
        result = result * 59 + this.getWriterIdleTimeSeconds();
        result = result * 59 + this.getAllIdleTimeSeconds();
        result = result * 59 + this.getConnectTimeoutSeconds();
        String $bindingAddr = this.getBindingAddr();
        result = result * 59 + ($bindingAddr == null ? 43 : $bindingAddr.hashCode());
        return result;
    }

    public String toString() {
        return "NettyServerConfig(bindingAddr=" + this.getBindingAddr() + ", bindingPort=" + this.getBindingPort() + ", backlog=" + this.getBacklog() + ", acceptThreads=" + this.getAcceptThreads() + ", workerThreads=" + this.getWorkerThreads() + ", rcvBuf=" + this.getRcvBuf() + ", sndBuf=" + this.getSndBuf() + ", readerIdleTimeSeconds=" + this.getReaderIdleTimeSeconds() + ", writerIdleTimeSeconds=" + this.getWriterIdleTimeSeconds() + ", allIdleTimeSeconds=" + this.getAllIdleTimeSeconds() + ", connectTimeoutSeconds=" + this.getConnectTimeoutSeconds() + ")";
    }
}

