/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local;

import com.evps.comm.local.repository.ApplicationRepository;
import com.evps.comm.local.xnet.client.EvpsLocalClientCommService;
import com.its.common.spring.SpringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.Banner;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.ApplicationPidFileWriter;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@SpringBootApplication
@EnableTransactionManagement
@ComponentScan(basePackages={"com.its.common.spring", "com.evps.comm.local.config", "com.evps.comm.local"})
public class EvpsCommLocalApplication
implements CommandLineRunner,
ApplicationListener<ContextClosedEvent>,
InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(EvpsCommLocalApplication.class);
    private static final String APPLICATION_NAME = "evps-comm-local";

    public static void main(String[] args) {
        SpringApplication application = new SpringApplicationBuilder(new Class[0]).sources(new Class[]{EvpsCommLocalApplication.class}).listeners(new ApplicationListener[]{new ApplicationPidFileWriter("./conf/evps-comm-local.pid")}).build();
        application.setBannerMode(Banner.Mode.OFF);
        application.run(args);
    }

    public void run(String ... args) throws Exception {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.info("");
        log.info("");
        log.info("************************************************************************************");
        log.info("**                                                                                **");
        log.info("**                            UTIC Signal System                                  **");
        log.info("**     UTIC Emergency Vehicle Preemption System Communication Local Program.      **");
        log.info("**                                                                                **");
        log.info("**                                                                   [ver.1.0]    **");
        log.info("** startup: {}", (Object)sdfDate.format(new Date()));
        log.info("************************************************************************************");
        ApplicationRepository applicationRepository = (ApplicationRepository)SpringUtils.getBean(ApplicationRepository.class);
        applicationRepository.loadDb();
        EvpsLocalClientCommService evpsLocalClientCommService = (EvpsLocalClientCommService)SpringUtils.getBean(EvpsLocalClientCommService.class);
        evpsLocalClientCommService.run();
    }

    public void onApplicationEvent(ContextClosedEvent contextClosedEvent) {
        SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        log.error("************************************************************************************");
        log.error("**    Application Terminated: {}, {}, {}", new Object[]{sdfDate.format(new Date()), contextClosedEvent.getTimestamp(), contextClosedEvent});
        try {
            EvpsLocalClientCommService evpsLocalClientCommService = (EvpsLocalClientCommService)SpringUtils.getBean(EvpsLocalClientCommService.class);
            evpsLocalClientCommService.shutdown();
        }
        catch (Exception e) {
            log.error("**    onApplicationEvent Exception: {}", (Object)e.getMessage());
        }
        log.error("************************************************************************************");
    }

    public void destroy() throws Exception {
        log.error("Application destroy.");
    }

    public void afterPropertiesSet() throws Exception {
        log.info("Application afterPropertiesSet.");
    }
}

