/*
 * Decompiled with CFR 0.152.
 */
package com.evps.comm.local.dto;

import com.evps.comm.local.dto.CenterDto;
import com.evps.comm.local.dto.PacketSequence;
import com.evps.comm.local.xnet.client.process.request.EvpsFrameData;
import com.evps.common.dto.NetState;
import io.netty.channel.ChannelFuture;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CenterDto
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CenterDto.class);
    private static final long serialVersionUID = 1L;
    private int idx;
    private String centerId;
    private String centerInfo;
    private String ipAddress;
    private int commPort;
    private String datexUser;
    private String datexPasswd;
    private int heartBeat;
    private int resTime;
    private int datagramSize;
    private boolean commLogging;
    private PacketSequence seq;
    private NetState netState;
    private long lastCommTm;

    public void setCenter(CenterDto dto) {
        this.idx = dto.getIdx();
        this.centerId = dto.getCenterId();
        this.centerInfo = dto.getCenterInfo();
        this.ipAddress = dto.getIpAddress();
        this.commPort = dto.getCommPort();
        this.datexUser = dto.getDatexUser();
        this.datexPasswd = dto.getDatexPasswd();
        this.heartBeat = dto.getHeartBeat();
        this.resTime = dto.getResTime();
        this.datagramSize = dto.getDatagramSize();
        this.commLogging = dto.isCommLogging();
        this.lastCommTm = dto.getLastCommTm();
        this.seq = new PacketSequence();
        this.netState = new NetState();
    }

    public String getLogKey() {
        return this.centerId;
    }

    public boolean sendData(EvpsFrameData data) {
        if (this.netState.getChannel() == null) {
            log.warn("SEND: [{}, {}]. Channel closed. {}.", new Object[]{this.centerId, this.ipAddress, data.getMsgType()});
            return false;
        }
        ChannelFuture f = this.netState.getChannel().writeAndFlush((Object)data.getByteBuffer());
        f.awaitUninterruptibly();
        if (f.isDone() || f.isSuccess()) {
            this.lastCommTm = System.currentTimeMillis();
            log.info("SEND: [{}, {}]. Packet send Ok. {}.", new Object[]{this.centerId, this.ipAddress, data.getMsgType()});
            return true;
        }
        log.error("SEND: [{}, {}]. Packet send Failed. {}. will be closed.", new Object[]{this.centerId, this.ipAddress, data.getMsgType()});
        return false;
    }

    public boolean channelOpened() {
        return this.netState.getChannel() != null && this.netState.getState() == 4;
    }

    public static CenterDtoBuilder builder() {
        return new CenterDtoBuilder();
    }

    public int getIdx() {
        return this.idx;
    }

    public String getCenterId() {
        return this.centerId;
    }

    public String getCenterInfo() {
        return this.centerInfo;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getCommPort() {
        return this.commPort;
    }

    public String getDatexUser() {
        return this.datexUser;
    }

    public String getDatexPasswd() {
        return this.datexPasswd;
    }

    public int getHeartBeat() {
        return this.heartBeat;
    }

    public int getResTime() {
        return this.resTime;
    }

    public int getDatagramSize() {
        return this.datagramSize;
    }

    public boolean isCommLogging() {
        return this.commLogging;
    }

    public PacketSequence getSeq() {
        return this.seq;
    }

    public NetState getNetState() {
        return this.netState;
    }

    public long getLastCommTm() {
        return this.lastCommTm;
    }

    public void setIdx(int idx) {
        this.idx = idx;
    }

    public void setCenterId(String centerId) {
        this.centerId = centerId;
    }

    public void setCenterInfo(String centerInfo) {
        this.centerInfo = centerInfo;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setCommPort(int commPort) {
        this.commPort = commPort;
    }

    public void setDatexUser(String datexUser) {
        this.datexUser = datexUser;
    }

    public void setDatexPasswd(String datexPasswd) {
        this.datexPasswd = datexPasswd;
    }

    public void setHeartBeat(int heartBeat) {
        this.heartBeat = heartBeat;
    }

    public void setResTime(int resTime) {
        this.resTime = resTime;
    }

    public void setDatagramSize(int datagramSize) {
        this.datagramSize = datagramSize;
    }

    public void setCommLogging(boolean commLogging) {
        this.commLogging = commLogging;
    }

    public void setSeq(PacketSequence seq) {
        this.seq = seq;
    }

    public void setNetState(NetState netState) {
        this.netState = netState;
    }

    public void setLastCommTm(long lastCommTm) {
        this.lastCommTm = lastCommTm;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CenterDto)) {
            return false;
        }
        CenterDto other = (CenterDto)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getIdx() != other.getIdx()) {
            return false;
        }
        if (this.getCommPort() != other.getCommPort()) {
            return false;
        }
        if (this.getHeartBeat() != other.getHeartBeat()) {
            return false;
        }
        if (this.getResTime() != other.getResTime()) {
            return false;
        }
        if (this.getDatagramSize() != other.getDatagramSize()) {
            return false;
        }
        if (this.isCommLogging() != other.isCommLogging()) {
            return false;
        }
        if (this.getLastCommTm() != other.getLastCommTm()) {
            return false;
        }
        String this$centerId = this.getCenterId();
        String other$centerId = other.getCenterId();
        if (this$centerId == null ? other$centerId != null : !this$centerId.equals(other$centerId)) {
            return false;
        }
        String this$centerInfo = this.getCenterInfo();
        String other$centerInfo = other.getCenterInfo();
        if (this$centerInfo == null ? other$centerInfo != null : !this$centerInfo.equals(other$centerInfo)) {
            return false;
        }
        String this$ipAddress = this.getIpAddress();
        String other$ipAddress = other.getIpAddress();
        if (this$ipAddress == null ? other$ipAddress != null : !this$ipAddress.equals(other$ipAddress)) {
            return false;
        }
        String this$datexUser = this.getDatexUser();
        String other$datexUser = other.getDatexUser();
        if (this$datexUser == null ? other$datexUser != null : !this$datexUser.equals(other$datexUser)) {
            return false;
        }
        String this$datexPasswd = this.getDatexPasswd();
        String other$datexPasswd = other.getDatexPasswd();
        if (this$datexPasswd == null ? other$datexPasswd != null : !this$datexPasswd.equals(other$datexPasswd)) {
            return false;
        }
        PacketSequence this$seq = this.getSeq();
        PacketSequence other$seq = other.getSeq();
        if (this$seq == null ? other$seq != null : !this$seq.equals(other$seq)) {
            return false;
        }
        NetState this$netState = this.getNetState();
        NetState other$netState = other.getNetState();
        return !(this$netState == null ? other$netState != null : !this$netState.equals(other$netState));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CenterDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIdx();
        result = result * 59 + this.getCommPort();
        result = result * 59 + this.getHeartBeat();
        result = result * 59 + this.getResTime();
        result = result * 59 + this.getDatagramSize();
        result = result * 59 + (this.isCommLogging() ? 79 : 97);
        long $lastCommTm = this.getLastCommTm();
        result = result * 59 + (int)($lastCommTm >>> 32 ^ $lastCommTm);
        String $centerId = this.getCenterId();
        result = result * 59 + ($centerId == null ? 43 : $centerId.hashCode());
        String $centerInfo = this.getCenterInfo();
        result = result * 59 + ($centerInfo == null ? 43 : $centerInfo.hashCode());
        String $ipAddress = this.getIpAddress();
        result = result * 59 + ($ipAddress == null ? 43 : $ipAddress.hashCode());
        String $datexUser = this.getDatexUser();
        result = result * 59 + ($datexUser == null ? 43 : $datexUser.hashCode());
        String $datexPasswd = this.getDatexPasswd();
        result = result * 59 + ($datexPasswd == null ? 43 : $datexPasswd.hashCode());
        PacketSequence $seq = this.getSeq();
        result = result * 59 + ($seq == null ? 43 : $seq.hashCode());
        NetState $netState = this.getNetState();
        result = result * 59 + ($netState == null ? 43 : $netState.hashCode());
        return result;
    }

    public String toString() {
        return "CenterDto(idx=" + this.getIdx() + ", centerId=" + this.getCenterId() + ", centerInfo=" + this.getCenterInfo() + ", ipAddress=" + this.getIpAddress() + ", commPort=" + this.getCommPort() + ", datexUser=" + this.getDatexUser() + ", datexPasswd=" + this.getDatexPasswd() + ", heartBeat=" + this.getHeartBeat() + ", resTime=" + this.getResTime() + ", datagramSize=" + this.getDatagramSize() + ", commLogging=" + this.isCommLogging() + ", seq=" + this.getSeq() + ", netState=" + this.getNetState() + ", lastCommTm=" + this.getLastCommTm() + ")";
    }

    public CenterDto() {
    }

    public CenterDto(int idx, String centerId, String centerInfo, String ipAddress, int commPort, String datexUser, String datexPasswd, int heartBeat, int resTime, int datagramSize, boolean commLogging, PacketSequence seq, NetState netState, long lastCommTm) {
        this.idx = idx;
        this.centerId = centerId;
        this.centerInfo = centerInfo;
        this.ipAddress = ipAddress;
        this.commPort = commPort;
        this.datexUser = datexUser;
        this.datexPasswd = datexPasswd;
        this.heartBeat = heartBeat;
        this.resTime = resTime;
        this.datagramSize = datagramSize;
        this.commLogging = commLogging;
        this.seq = seq;
        this.netState = netState;
        this.lastCommTm = lastCommTm;
    }
}

